/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.BalkonsWeaponMod;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityProjectile
extends EntityArrow
implements IThrowableEntity,
IEntityAdditionalSpawnData {
    private static final Predicate<Entity> WEAPON_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, Entity::func_70067_L});
    private static final DataParameter<Byte> WEAPON_CRITICAL = EntityDataManager.func_187226_a(EntityProjectile.class, (DataSerializer)DataSerializers.field_187191_a);
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    @Nullable
    protected IBlockState inBlockState = null;
    protected boolean inGround = false;
    public PickupStatus pickupStatus;
    protected int ticksInGround;
    protected int ticksInAir;
    public boolean beenInGround;
    public float extraDamage;
    public int knockBack;

    public EntityProjectile(World world) {
        super(world);
        this.field_70249_b = 0;
        this.ticksInAir = 0;
        this.pickupStatus = PickupStatus.DISALLOWED;
        this.extraDamage = 0.0f;
        this.knockBack = 0;
        this.func_70105_a(0.5f, 0.5f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WEAPON_CRITICAL, (Object)0);
    }

    public void writeSpawnData(ByteBuf buf) {
        Entity shooter = this.getThrower();
        buf.writeInt(shooter != null ? shooter.func_145782_y() : -1);
    }

    public void readSpawnData(ByteBuf buf) {
        int shooterId = buf.readInt();
        if (shooterId >= 0) {
            this.setThrower(this.field_70170_p.func_73045_a(shooterId));
        }
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    protected void setPickupStatusFromEntity(EntityLivingBase entityliving) {
        if (entityliving instanceof EntityPlayer) {
            if (((EntityPlayer)entityliving).func_184812_l_()) {
                this.setPickupStatus(PickupStatus.CREATIVE_ONLY);
            } else {
                this.setPickupStatus(BalkonsWeaponMod.instance.modConfig.allCanPickup ? PickupStatus.ALLOWED : PickupStatus.OWNER_ONLY);
            }
        } else {
            this.setPickupStatus(PickupStatus.DISALLOWED);
        }
    }

    public Entity getDamagingEntity() {
        Entity shooter = this.getThrower();
        return shooter != null ? shooter : this;
    }

    public void func_70186_c(double x, double y, double z, float speed, float deviation) {
        float n2;
        float n;
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)deviation;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)deviation;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)deviation;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f2 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = n = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
        this.field_70126_B = n;
        this.field_70125_A = n2 = (float)(MathHelper.func_181159_b((double)y, (double)f2) * 180.0 / Math.PI);
        this.field_70127_C = n2;
        this.ticksInGround = 0;
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
        if (this.aimRotation() && this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float n2;
            float n;
            float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            this.field_70177_z = n = (float)(MathHelper.func_181159_b((double)d, (double)d2) * 180.0 / Math.PI);
            this.field_70126_B = n;
            this.field_70125_A = n2 = (float)(MathHelper.func_181159_b((double)d1, (double)f) * 180.0 / Math.PI);
            this.field_70127_C = n2;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        Entity entity;
        AxisAlignedBB axisalignedbb;
        BlockPos blockpos;
        IBlockState iblockstate;
        super.func_70030_z();
        if (this.aimRotation() && this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float n2;
            float n;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = n = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 180.0 / Math.PI);
            this.field_70126_B = n;
            this.field_70125_A = n2 = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 180.0 / Math.PI);
            this.field_70127_C = n2;
        }
        if ((iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.xTile, this.yTile, this.zTile))).func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d(this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.inGround) {
            if (!iblockstate.equals(this.inBlockState) && !this.field_70170_p.func_184143_b(this.func_174813_aQ().func_186662_g(0.05))) {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                ++this.ticksInGround;
                int t = this.getMaxLifetime();
                if (t != 0 && this.ticksInGround >= t) {
                    this.func_70106_y();
                }
            }
            ++this.field_184552_b;
            return;
        }
        this.field_184552_b = 0;
        ++this.ticksInAir;
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, vec3d2, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d2 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntity(vec3d, vec3d2)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null) {
            this.func_184549_a(raytraceresult);
        }
        if (this.func_70241_g()) {
            for (int i1 = 0; i1 < 2; ++i1) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)i1 / 4.0, this.field_70163_u + this.field_70181_x * (double)i1 / 4.0, this.field_70161_v + this.field_70179_y * (double)i1 / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        if (this.aimRotation()) {
            float n4;
            float n3;
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = n3 = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 180.0 / Math.PI);
            this.field_70126_B = n3;
            this.field_70125_A = n4 = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f2) * 180.0 / Math.PI);
            this.field_70127_C = n4;
        }
        float res = this.getAirResistance();
        float grav = this.getGravity();
        if (this.func_70090_H()) {
            this.beenInGround = true;
            for (int i2 = 0; i2 < 4; ++i2) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            res *= 0.6f;
        }
        this.field_70159_w *= (double)res;
        this.field_70181_x *= (double)res;
        this.field_70179_y *= (double)res;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)grav;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    public void func_184549_a(@NotNull RayTraceResult raytraceResult) {
        if (raytraceResult.field_72308_g != null) {
            this.onHitEntity(raytraceResult);
        } else {
            this.onHitBlock(raytraceResult);
        }
    }

    public void onHitEntity(RayTraceResult raytraceResult) {
        this.bounceBack();
        this.applyEntityHitEffects(raytraceResult.field_72308_g);
    }

    public void applyEntityHitEffects(Entity entity) {
        if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
            entity.func_70015_d(5);
        }
        if (entity instanceof EntityLivingBase) {
            float f;
            EntityLivingBase entityliving = (EntityLivingBase)entity;
            if (this.knockBack > 0 && (f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                entity.func_70024_g(this.field_70159_w * (double)this.knockBack * 0.6 / (double)f, 0.1, this.field_70179_y * (double)this.knockBack * 0.6 / (double)f);
            }
            if (this.field_70250_c instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)entityliving, (Entity)this.field_70250_c);
                EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entityliving);
            }
            if (this.field_70250_c instanceof EntityPlayerMP && this.field_70250_c != entity && entity instanceof EntityPlayer) {
                ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
            }
        }
    }

    public void onHitBlock(RayTraceResult raytraceResult) {
        BlockPos blockpos = raytraceResult.func_178782_a();
        this.xTile = blockpos.func_177958_n();
        this.yTile = blockpos.func_177956_o();
        this.zTile = blockpos.func_177952_p();
        this.inBlockState = this.field_70170_p.func_180495_p(blockpos);
        this.field_70159_w = raytraceResult.field_72307_f.field_72450_a - this.field_70165_t;
        this.field_70181_x = raytraceResult.field_72307_f.field_72448_b - this.field_70163_u;
        this.field_70179_y = raytraceResult.field_72307_f.field_72449_c - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.inGround = true;
        this.beenInGround = true;
        this.func_70243_d(false);
        this.field_70249_b = this.getMaxArrowShake();
        this.playHitSound();
        if (this.inBlockState != null) {
            this.inBlockState.func_177230_c().func_180634_a(this.field_70170_p, blockpos, this.inBlockState, (Entity)this);
        }
    }

    protected void bounceBack() {
        this.field_70159_w *= -0.1;
        this.field_70181_x *= -0.1;
        this.field_70179_y *= -0.1;
        this.field_70177_z += 180.0f;
        this.field_70126_B += 180.0f;
        this.ticksInAir = 0;
    }

    @Nullable
    protected Entity findEntity(Vec3d vec3d, Vec3d vec3d1) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), WEAPON_TARGETS);
        double d = 0.0;
        for (Entity entity2 : list) {
            double d2;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            if (entity2 == this.field_70250_c && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity2.func_174813_aQ().func_186662_g(0.3)).func_72327_a(vec3d, vec3d1)) == null || !((d2 = vec3d.func_72436_e(raytraceresult.field_72307_f)) < d) && d != 0.0) continue;
            entity = entity2;
            d = d2;
        }
        return entity;
    }

    public double getTotalVelocity() {
        return MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
    }

    public boolean aimRotation() {
        return true;
    }

    public int getMaxLifetime() {
        return 1200;
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return new ItemStack(Items.field_151032_g);
    }

    public ItemStack getPickupItem() {
        return this.func_184550_j();
    }

    @NotNull
    public ItemStack getPickedResult(@NotNull RayTraceResult target) {
        return this.getPickupItem();
    }

    public float getAirResistance() {
        return 0.99f;
    }

    public float getGravity() {
        return 0.05f;
    }

    public int getMaxArrowShake() {
        return 7;
    }

    public void playHitSound() {
    }

    public boolean canBeCritical() {
        return false;
    }

    public void func_70243_d(boolean flag) {
        if (this.canBeCritical()) {
            this.field_70180_af.func_187227_b(WEAPON_CRITICAL, (Object)((byte)(flag ? 1 : 0)));
        }
    }

    public boolean func_70241_g() {
        return this.canBeCritical() && (Byte)this.field_70180_af.func_187225_a(WEAPON_CRITICAL) != 0;
    }

    public void setExtraDamage(float f) {
        this.extraDamage = f;
    }

    public void func_70240_a(int i) {
        this.knockBack = i;
    }

    public void setPickupStatus(PickupStatus i) {
        this.pickupStatus = i;
    }

    public PickupStatus getPickupStatus() {
        return this.pickupStatus;
    }

    public boolean canPickup(EntityPlayer entityplayer) {
        if (this.pickupStatus == PickupStatus.ALLOWED) {
            return true;
        }
        if (this.pickupStatus == PickupStatus.CREATIVE_ONLY) {
            return entityplayer.func_184812_l_();
        }
        return this.pickupStatus == PickupStatus.OWNER_ONLY && entityplayer == this.field_70250_c;
    }

    public void func_70100_b_(@NotNull EntityPlayer entityplayer) {
        if (this.inGround && this.field_70249_b <= 0 && this.canPickup(entityplayer) && !this.field_70170_p.field_72995_K) {
            ItemStack item = this.getPickupItem();
            if (item == null) {
                return;
            }
            if (this.pickupStatus == PickupStatus.CREATIVE_ONLY && entityplayer.func_184812_l_() || entityplayer.field_71071_by.func_70441_a(item)) {
                this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.func_70106_y();
            }
        }
    }

    protected void onItemPickup(EntityPlayer entityplayer) {
        entityplayer.func_71001_a((Entity)this, 1);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("xTile", this.xTile);
        nbttagcompound.func_74768_a("yTile", this.yTile);
        nbttagcompound.func_74768_a("zTile", this.zTile);
        if (this.inBlockState != null) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)compound, (IBlockState)this.inBlockState);
            nbttagcompound.func_74782_a("inBlockState", (NBTBase)compound);
        }
        nbttagcompound.func_74774_a("shake", (byte)this.field_70249_b);
        nbttagcompound.func_74757_a("inGround", this.inGround);
        nbttagcompound.func_74757_a("beenInGround", this.beenInGround);
        nbttagcompound.func_74774_a("pickup", (byte)this.pickupStatus.ordinal());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.xTile = nbttagcompound.func_74762_e("xTile");
        this.yTile = nbttagcompound.func_74762_e("yTile");
        this.zTile = nbttagcompound.func_74762_e("zTile");
        if (nbttagcompound.func_150297_b("inBlockState", 10)) {
            this.inBlockState = NBTUtil.func_190008_d((NBTTagCompound)nbttagcompound.func_74775_l("inBlockState"));
        }
        this.field_70249_b = nbttagcompound.func_74771_c("shake") & 0xFF;
        this.inGround = nbttagcompound.func_74767_n("inGround");
        this.beenInGround = nbttagcompound.func_74767_n("beenInGround");
        this.pickupStatus = PickupStatus.getByOrdinal(nbttagcompound.func_74771_c("pickup"));
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY,
        OWNER_ONLY;


        public static PickupStatus getByOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }
    }
}

