/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.entity.projectile.EntityMusketBullet;
import ckathode.weaponmod.item.ItemMusket;
import ckathode.weaponmod.item.RangedComponent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class RangedCompMusket
extends RangedComponent {
    protected ItemMusket musket;

    public RangedCompMusket() {
        super(RangedComponent.RangedSpecs.MUSKET);
    }

    @Override
    protected void onSetItem() {
        super.onSetItem();
        if (this.item instanceof ItemMusket) {
            this.musket = (ItemMusket)this.item;
        }
    }

    @Override
    public void effectReloadDone(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        entityplayer.func_184609_a(EnumHand.MAIN_HAND);
        world.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187556_aj, SoundCategory.PLAYERS, 1.0f, 1.0f / (this.weapon.getItemRand().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public void fire(ItemStack itemstack, World world, EntityLivingBase entityliving, int i) {
        boolean flag;
        EntityPlayer entityplayer = (EntityPlayer)entityliving;
        int j = this.getMaxItemUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        f += 0.02f;
        if (!world.field_72995_K) {
            EntityMusketBullet entitymusketbullet = new EntityMusketBullet(world, (EntityLivingBase)entityplayer);
            entitymusketbullet.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, 5.0f, 1.0f / f);
            this.applyProjectileEnchantments(entitymusketbullet, itemstack);
            world.func_72838_d((Entity)entitymusketbullet);
        }
        int deltaDamage = 1;
        boolean bl = flag = itemstack.func_77952_i() + deltaDamage >= itemstack.func_77958_k();
        if (flag && this.musket != null && this.musket.hasBayonet()) {
            short bayonetDamage = itemstack.func_77942_o() ? itemstack.func_77978_p().func_74765_d("bayonetDamage") : (short)0;
            ItemStack newStack = new ItemStack(this.musket.bayonetItem, 1, (int)bayonetDamage);
            itemstack.func_77972_a(deltaDamage, (EntityLivingBase)entityplayer);
            if (itemstack.field_77994_a <= 0) {
                entityplayer.field_71071_by.func_184437_d(itemstack);
            }
            entityplayer.field_71071_by.func_70441_a(newStack);
        } else {
            itemstack.func_77972_a(deltaDamage, (EntityLivingBase)entityplayer);
            if (itemstack.field_77994_a <= 0) {
                entityplayer.field_71071_by.func_184437_d(itemstack);
            }
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
        }
        this.postShootingEffects(itemstack, entityplayer, world);
    }

    @Override
    public void effectPlayer(ItemStack itemstack, EntityPlayer entityplayer, World world) {
        float f = entityplayer.func_70093_af() ? -0.05f : -0.1f;
        double d = -MathHelper.func_76126_a((float)(entityplayer.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)0.0f) * f;
        double d2 = MathHelper.func_76134_b((float)(entityplayer.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)0.0f) * f;
        entityplayer.field_70125_A = entityplayer.field_70125_A - (entityplayer.func_70093_af() ? 7.5f : 15.0f);
        entityplayer.func_70024_g(d, 0.0, d2);
    }

    @Override
    public void effectShoot(World world, double x, double y, double z, float yaw, float pitch) {
        world.func_184148_a(null, x, y, z, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 3.0f, 1.0f / (this.weapon.getItemRand().nextFloat() * 0.4f + 0.7f));
        world.func_184148_a(null, x, y, z, SoundEvents.field_187754_de, SoundCategory.PLAYERS, 3.0f, 1.0f / (this.weapon.getItemRand().nextFloat() * 0.4f + 0.4f));
        float particleX = -MathHelper.func_76126_a((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float particleY = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180))) + 1.6f;
        float particleZ = MathHelper.func_76134_b((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        for (int i = 0; i < 3; ++i) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + (double)particleX, y + (double)particleY, z + (double)particleZ, 0.0, 0.0, 0.0, new int[0]);
        }
        world.func_175688_a(EnumParticleTypes.FLAME, x + (double)particleX, y + (double)particleY, z + (double)particleZ, 0.0, 0.0, 0.0, new int[0]);
    }

    @Override
    public float getMaxZoom() {
        return 0.15f;
    }
}

