/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiOverlayReloaded
extends Gui {
    @SubscribeEvent
    public void renderGUIOverlay(RenderGameOverlayEvent.Pre e) {
        if (!BalkonsWeaponMod.instance.modConfig.guiOverlayReloaded || e.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP p = mc.field_71439_g;
        if (p == null) {
            return;
        }
        this.renderForHand(EnumHand.MAIN_HAND, (EntityPlayer)p, e.getResolution());
        this.renderForHand(EnumHand.OFF_HAND, (EntityPlayer)p, e.getResolution());
    }

    private void renderForHand(EnumHand hand, EntityPlayer p, ScaledResolution res) {
        ItemStack is;
        Minecraft mc = Minecraft.func_71410_x();
        int currentItem = p.field_71071_by.field_70461_c;
        IItemWeapon item = null;
        ItemStack itemStack = is = hand == EnumHand.OFF_HAND ? p.func_184592_cb() : p.field_71071_by.func_70301_a(currentItem);
        if (is != null && is.func_77973_b() instanceof IItemWeapon) {
            item = (IItemWeapon)is.func_77973_b();
        }
        if (item == null) {
            return;
        }
        RangedComponent rc = item.getRangedComponent();
        MeleeComponent mec = item.getMeleeComponent();
        boolean set = false;
        float f = 0.0f;
        int offset = 0;
        if (rc != null) {
            if (p.func_184600_cs() == hand) {
                if (RangedComponent.isReloaded(is)) {
                    f = 1.0f;
                    offset = RangedComponent.isReadyToFire(is) ? 48 : 24;
                } else {
                    f = MathHelper.func_76131_a((float)((float)p.func_184612_cw() / (float)rc.getReloadDuration(is)), (float)0.0f, (float)1.0f);
                }
                set = true;
            }
        } else if (mec != null && mec.shouldRenderCooldown()) {
            f = MathHelper.func_76131_a((float)mec.getCooldown(), (float)0.0f, (float)1.0f);
            set = true;
        }
        if (!set) {
            return;
        }
        EnumHandSide offHandSide = p.func_184591_cq().func_188468_a();
        int x0 = res.func_78326_a() / 2 + (hand == EnumHand.OFF_HAND ? (offHandSide == EnumHandSide.LEFT ? -120 : 91) : -92 + currentItem * 20);
        int y0 = res.func_78328_b() + 1;
        int tx = hand == EnumHand.OFF_HAND ? (offHandSide == EnumHandSide.LEFT ? 24 : 53) : 0;
        int width = hand == EnumHand.OFF_HAND ? 29 : 24;
        int height = (int)(f * 24.0f);
        this.field_73735_i = -90.0f;
        mc.func_175598_ae().field_78724_e.func_110577_a(WeaponModResources.Gui.OVERLAY);
        this.func_73729_b(x0, y0 - height, tx, offset + 24 - height, width, height);
    }
}

