/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.item.ItemFlail;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import org.jetbrains.annotations.NotNull;

public class EntityFlail
extends EntityMaterialProjectile<EntityFlail> {
    public static final String ID = "flail";
    public static final class_1299<EntityFlail> TYPE = WMRegistries.createEntityType("flail", new class_4048(0.5f, 0.5f, false), EntityFlail::new);
    public boolean isSwinging;
    private float flailDamage;
    private class_243 distance;

    public EntityFlail(class_1299<EntityFlail> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5985 = true;
        this.flailDamage = 1.0f;
        this.distance = class_243.field_1353;
    }

    public EntityFlail(class_1937 world, double d, double d1, double d2) {
        this(TYPE, world);
        this.method_5814(d, d1, d2);
    }

    public EntityFlail(class_1937 worldIn, class_1309 shooter, class_1799 itemstack) {
        this(worldIn, shooter.method_23317(), shooter.method_23320() - 0.3, shooter.method_23321());
        this.method_7432((class_1297)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return NetworkManager.createAddEntityPacket((class_1297)this);
    }

    public void method_24919(class_1297 entity, float f, float f1, float f2, float f3, float f4) {
        class_243 entityMotion = entity.method_18798();
        this.method_18799(this.method_18798().method_1031(entityMotion.field_1352, entity.method_24828() ? 0.0 : entityMotion.field_1351, entityMotion.field_1350));
        this.swing(f, f1, f3, f4);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1297 shooter = this.method_24921();
        if (shooter != null) {
            this.distance = shooter.method_19538().method_1020(this.method_19538());
            if (this.distance.method_1027() > 9.0) {
                this.returnToOwner(true);
            }
            if (shooter instanceof class_1657) {
                class_1799 itemstack = ((class_1657)shooter).method_6047();
                class_1799 thrownItem = this.getWeapon();
                if (itemstack.method_7960() || !thrownItem.method_7960() && itemstack.method_7909() != thrownItem.method_7909() || !shooter.method_5805()) {
                    this.pickUpByOwner();
                }
            }
        } else if (!this.field_6002.field_9236) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.inGround) {
            this.inGround = false;
            return;
        }
        this.returnToOwner(false);
    }

    public void returnToOwner(boolean looseFromGround) {
        class_1297 shooter;
        if (looseFromGround) {
            this.inGround = false;
        }
        if ((shooter = this.method_24921()) == null) {
            return;
        }
        double targetPosX = shooter.method_23317();
        double targetPosY = shooter.method_5829().field_1322 + (double)0.4f;
        double targetPosZ = shooter.method_23321();
        float f = 27.0f;
        float f2 = 2.0f;
        this.distance = new class_243(targetPosX += -Math.sin((shooter.method_36454() + f) * ((float)Math.PI / 180)) * Math.cos(shooter.method_36455() * ((float)Math.PI / 180)) * (double)f2, targetPosY, targetPosZ += Math.cos((shooter.method_36454() + f) * ((float)Math.PI / 180)) * Math.cos(shooter.method_36455() * ((float)Math.PI / 180)) * (double)f2).method_1020(this.method_19538());
        double distanceTotalSqr = this.distance.method_1027();
        if (distanceTotalSqr > 9.0) {
            this.method_5814(targetPosX, targetPosY, targetPosZ);
        } else if (distanceTotalSqr > 6.25) {
            this.isSwinging = false;
            this.method_18799(this.method_18798().method_1021(-0.5));
        }
        if (!this.isSwinging) {
            float f3 = 0.2f;
            this.method_18799(this.distance.method_1021((double)f3 * Math.sqrt(distanceTotalSqr)));
        }
    }

    public void pickUpByOwner() {
        this.method_5650(class_1297.class_5529.field_26999);
        class_1297 shooter = this.method_24921();
        if (shooter instanceof class_1657 && !this.getWeapon().method_7960()) {
            PlayerWeaponData.setFlailThrown((class_1657)shooter, false);
        }
    }

    public void swing(float f, float f1, float f2, float f3) {
        if (this.isSwinging) {
            return;
        }
        this.method_5783(class_3417.field_14600, 0.5f, 0.4f / (this.field_5974.method_43057() * 0.4f + 0.8f));
        float x = -class_3532.method_15374((float)(f1 * ((float)Math.PI / 180))) * class_3532.method_15362((float)(f * ((float)Math.PI / 180)));
        float y = -class_3532.method_15374((float)(f * ((float)Math.PI / 180)));
        float z = class_3532.method_15362((float)(f1 * ((float)Math.PI / 180))) * class_3532.method_15362((float)(f * ((float)Math.PI / 180)));
        this.method_7485(x, y, z, f2, f3);
        this.isSwinging = true;
        this.inGround = false;
    }

    @Override
    public void method_7454(class_3966 result) {
        class_1297 entity = result.method_17782();
        if (entity.equals((Object)this.method_24921())) {
            return;
        }
        class_1297 shooter = this.getDamagingEntity();
        class_1282 damagesource = shooter instanceof class_1309 ? this.method_48923().method_48812((class_1309)shooter) : this.method_48923().method_48797(WMDamageSources.WEAPON, (class_1297)this, shooter);
        if (entity.method_5643(damagesource, this.flailDamage + this.extraDamage)) {
            this.playHitSound();
            this.returnToOwner(true);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void bounceBack() {
        this.method_18799(this.method_18798().method_1021(-0.8));
        this.method_36456(this.method_36454() + 180.0f);
        this.field_5982 += 180.0f;
        this.ticksInAir = 0;
    }

    @Override
    public void playHitSound() {
        if (this.inGround) {
            return;
        }
        this.method_5783(class_3417.field_15115, 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
    }

    @Override
    public void setThrownItemStack(@NotNull class_1799 itemstack) {
        if (!(itemstack.method_7909() instanceof ItemFlail)) {
            return;
        }
        super.setThrownItemStack(itemstack);
        this.flailDamage = ((ItemFlail)itemstack.method_7909()).getFlailDamage();
    }

    @Override
    public void method_5652(class_2487 nbttagcompound) {
        super.method_5652(nbttagcompound);
        nbttagcompound.method_10548("fDmg", this.flailDamage);
    }

    @Override
    public void method_5749(class_2487 nbttagcompound) {
        super.method_5749(nbttagcompound);
        this.flailDamage = nbttagcompound.method_10583("fDmg");
    }

    @Override
    public void method_5694(@NotNull class_1657 entityplayer) {
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }
}

