/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.entity.projectile.MaterialRegistry;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.ItemHitEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class EntityMaterialProjectile<T extends EntityMaterialProjectile<T>>
extends EntityProjectile<T> {
    private static final class_2940<Integer> WEAPON_MATERIAL = class_2945.method_12791(EntityMaterialProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_1799> WEAPON_ITEM = class_2945.method_12791(EntityMaterialProjectile.class, (class_2941)class_2943.field_13322);
    private static final float[][] MATERIAL_COLORS = new float[][]{{0.6f, 0.4f, 0.1f}, {0.5f, 0.5f, 0.5f}, {1.0f, 1.0f, 1.0f}, {0.0f, 0.8f, 0.7f}, {1.0f, 0.9f, 0.0f}, {0.3f, 0.3f, 0.3f}};

    public EntityMaterialProjectile(class_1299<T> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(WEAPON_MATERIAL, (Object)0);
        this.field_6011.method_12784(WEAPON_ITEM, (Object)class_1799.field_8037);
    }

    @Override
    public void saveAdditionalSpawnData(class_2540 buf) {
        super.saveAdditionalSpawnData(buf);
        buf.writeInt(this.getWeaponMaterialId());
        buf.method_10793(this.getWeapon());
    }

    @Override
    public void loadAdditionalSpawnData(class_2540 buf) {
        super.loadAdditionalSpawnData(buf);
        this.field_6011.method_12778(WEAPON_MATERIAL, (Object)buf.readInt());
        this.field_6011.method_12778(WEAPON_ITEM, (Object)buf.method_10819());
    }

    public float getMeleeHitDamage(class_1297 entity) {
        class_1297 shooter = this.method_24921();
        if (shooter instanceof class_1309 && entity instanceof class_1309) {
            return class_1890.method_8218((class_1799)((class_1309)shooter).method_6047(), (class_1310)((class_1309)entity).method_6046());
        }
        return 0.0f;
    }

    @Override
    public void method_7454(class_3966 result) {
        super.method_7454(result);
        class_1799 thrownItem = this.getWeapon();
        if (!thrownItem.method_7960() && thrownItem.method_7909() instanceof ItemHitEffect) {
            ((ItemHitEffect)thrownItem.method_7909()).onHitEntity(this, result);
        }
    }

    @Override
    public void method_24920(class_3965 result) {
        super.method_24920(result);
        class_1799 thrownItem = this.getWeapon();
        if (!thrownItem.method_7960() && thrownItem.method_7909() instanceof ItemHitEffect) {
            ((ItemHitEffect)thrownItem.method_7909()).onHitBlock(this, result);
        }
    }

    @Override
    public void applyEntityHitEffects(class_1297 entity) {
        super.applyEntityHitEffects(entity);
        class_1297 shooter = this.method_24921();
        if (shooter instanceof class_1309 && entity instanceof class_1309) {
            int i = class_1890.method_8205((class_1309)((class_1309)shooter));
            if (i != 0) {
                ((class_1309)entity).method_6005((double)((float)i * 0.4f), (double)(-class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
            }
            if ((i = class_1890.method_8199((class_1309)((class_1309)shooter))) > 0 && !entity.method_5809()) {
                entity.method_5639(1);
            }
        }
    }

    public void setThrownItemStack(@NotNull class_1799 itemstack) {
        this.field_6011.method_12778(WEAPON_ITEM, (Object)itemstack);
        this.updateWeaponMaterial();
    }

    @Override
    @NotNull
    public class_1799 method_7445() {
        return this.getWeapon();
    }

    public int getWeaponMaterialId() {
        return (Integer)this.field_6011.method_12789(WEAPON_MATERIAL);
    }

    @NotNull
    public class_1799 getWeapon() {
        return (class_1799)this.field_6011.method_12789(WEAPON_ITEM);
    }

    protected void updateWeaponMaterial() {
        IItemWeapon weapon;
        class_1792 class_17922;
        class_1799 thrownItem = this.getWeapon();
        if (!thrownItem.method_7960() && (class_17922 = thrownItem.method_7909()) instanceof IItemWeapon && (weapon = (IItemWeapon)class_17922).getMeleeComponent() != null) {
            int material = MaterialRegistry.getMaterialID(thrownItem);
            if (material < 0) {
                material = MaterialRegistry.getOrdinal(weapon.getMeleeComponent().weaponMaterial);
            }
            this.field_6011.method_12778(WEAPON_MATERIAL, (Object)material);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public float[] getMaterialColor() {
        int id = this.getWeaponMaterialId();
        if (id >= 0 && id < MATERIAL_COLORS.length) {
            return MATERIAL_COLORS[id];
        }
        return MaterialRegistry.getColorFromMaterialID(id);
    }

    @Override
    public void method_5652(class_2487 nbttagcompound) {
        super.method_5652(nbttagcompound);
        class_1799 thrownItem = this.getWeapon();
        nbttagcompound.method_10566("thrI", (class_2520)thrownItem.method_7953(new class_2487()));
    }

    @Override
    public void method_5749(class_2487 nbttagcompound) {
        super.method_5749(nbttagcompound);
        if (nbttagcompound.method_10545("thrI")) {
            this.setThrownItemStack(class_1799.method_7915((class_2487)nbttagcompound.method_10562("thrI")));
        }
    }
}

