/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.IExtendedReachItem;
import ckathode.weaponmod.item.IItemWeapon;
import com.google.common.collect.Multimap;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_5134;

public class MeleeComponent
extends AbstractWeaponComponent {
    public final MeleeSpecs meleeSpecs;
    public final class_1832 weaponMaterial;

    public MeleeComponent(MeleeSpecs meleespecs, class_1832 itemTier) {
        this.meleeSpecs = meleespecs;
        this.weaponMaterial = itemTier;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public class_1792.class_1793 setProperties(class_1792.class_1793 properties) {
        return properties.method_7898(this.weaponMaterial == null ? this.meleeSpecs.durabilityBase : (int)((float)this.meleeSpecs.durabilityBase + (float)this.weaponMaterial.method_8025() * this.meleeSpecs.durabilityMult));
    }

    @Override
    public float getDamage() {
        if (this.weaponMaterial == null) {
            return 0.0f;
        }
        return this.weaponMaterial.method_8028() * this.meleeSpecs.damageMult;
    }

    @Override
    public float getEntityDamage() {
        return this.meleeSpecs.damageBase + this.getDamage();
    }

    @Override
    public float getDestroySpeed(class_1799 itemstack, class_2680 block) {
        if (this.canHarvestBlock(block)) {
            return this.meleeSpecs.blockDamage * 10.0f;
        }
        class_3614 material = block.method_26207();
        return material != class_3614.field_15935 && material != class_3614.field_15956 && material != class_3614.field_15947 && material != class_3614.field_15923 && material != class_3614.field_15954 ? 1.0f : this.meleeSpecs.blockDamage;
    }

    @Override
    public boolean canHarvestBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        return block == class_2246.field_10343;
    }

    @Override
    public boolean mineBlock(class_1799 itemstack, class_1937 world, class_2680 block, class_2338 pos, class_1309 entityliving) {
        if (block.method_26214((class_1922)world, pos) != 0.0f) {
            itemstack.method_7956(this.meleeSpecs.dmgFromBlock, entityliving, s -> s.method_20236(class_1268.field_5808));
        }
        return true;
    }

    @Override
    public boolean hurtEnemy(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        int n = entityliving.field_6008;
        Objects.requireNonNull(entityliving);
        if (n == 20) {
            float kb = this.getKnockBack(itemstack, entityliving, attacker);
            PhysHelper.knockBack(entityliving, attacker, kb);
            if (this.meleeSpecs.attackDelay >= 3.0f) {
                entityliving.field_6008 += (int)this.getAttackDelay(itemstack, entityliving, attacker);
            } else {
                float f = this.meleeSpecs.attackDelay < 1.0f ? 1.2f : 2.0f;
                entityliving.field_6008 -= (int)(f / this.getAttackDelay(itemstack, entityliving, attacker));
            }
        }
        itemstack.method_7956(this.meleeSpecs.dmgFromEntity, attacker, s -> s.method_20236(class_1268.field_5808));
        return true;
    }

    @Override
    public float getAttackDelay(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        return this.meleeSpecs.attackDelay;
    }

    @Override
    public float getKnockBack(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        return this.meleeSpecs.getKnockBack(this.weaponMaterial);
    }

    @Override
    public int getEnchantmentValue() {
        return this.weaponMaterial == null ? 1 : this.weaponMaterial.method_8026();
    }

    @Override
    public void addItemAttributeModifiers(Multimap<class_1320, class_1322> multimap) {
        float dmg = this.getEntityDamage();
        if (dmg > 0.0f || this.meleeSpecs.damageMult > 0.0f) {
            multimap.put((Object)class_5134.field_23721, (Object)new class_1322(IItemWeapon.ATTACK_DAMAGE_MODIFIER, "Weapon attack damage modifier", (double)dmg, class_1322.class_1323.field_6328));
            multimap.put((Object)class_5134.field_23723, (Object)new class_1322(IItemWeapon.ATTACK_SPEED_MODIFIER, "Weapon attack speed modifier", (double)(-this.meleeSpecs.attackDelay), class_1322.class_1323.field_6328));
        }
        if (this.meleeSpecs.getKnockBack(this.weaponMaterial) != 0.4f) {
            multimap.put((Object)WeaponModAttributes.WEAPON_KNOCKBACK, (Object)new class_1322(IItemWeapon.KNOCKBACK_MODIFIER, "Weapon knockback modifier", (double)(this.meleeSpecs.getKnockBack(this.weaponMaterial) - 0.4f), class_1322.class_1323.field_6328));
        }
        if (this instanceof IExtendedReachItem) {
            try {
                multimap.put((Object)WeaponModAttributes.WEAPON_REACH, (Object)new class_1322(IItemWeapon.REACH_MODIFIER, "Weapon reach modifier", (double)(((IExtendedReachItem)((Object)this)).getExtendedReach(null, null, null) - 3.0f), class_1322.class_1323.field_6328));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean onLeftClickEntity(class_1799 itemstack, class_1657 player, class_1297 entity) {
        if (entity instanceof class_1309) {
            PhysHelper.prepareKnockbackOnEntity((class_1309)player, (class_1309)entity);
        }
        return false;
    }

    @Override
    public class_1839 getUseAnimation(class_1799 itemstack) {
        return class_1839.field_8949;
    }

    @Override
    public int getUseDuration(class_1799 itemstack) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 entityplayer, class_1268 hand) {
        class_1799 itemstack = entityplayer.method_5998(hand);
        if (this.getUseAnimation(itemstack) != class_1839.field_8952) {
            entityplayer.method_6019(hand);
        }
        return new class_1271(class_1269.field_5811, (Object)itemstack);
    }

    @Override
    public void onUsingTick(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
    }

    @Override
    public void releaseUsing(class_1799 itemstack, class_1937 world, class_1309 entityliving, int i) {
    }

    @Override
    public void inventoryTick(class_1799 itemstack, class_1937 world, class_1297 entity, int i, boolean flag) {
    }

    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderCooldown() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public float getCooldown() {
        return 0.0f;
    }

    public static enum MeleeSpecs {
        SPEAR(0, 1.0f, 3.0f, 1.0f, 1.0f, 0.2f, 1, 2, 2.7f),
        HALBERD(0, 1.0f, 4.0f, 1.0f, 1.5f, 0.6f, 1, 2, 3.2f),
        BATTLEAXE(0, 1.0f, 3.0f, 1.0f, 1.5f, 0.5f, 1, 2, 3.0f),
        WARHAMMER(0, 1.0f, 4.0f, 1.0f, 1.0f, 0.7f, 1, 2, 3.0f),
        KNIFE(0, 0.5f, 3.0f, 1.0f, 1.5f, 0.2f, 1, 2, 2.0f),
        KATANA(0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1, 2, 0.2f),
        FIREROD(1, 0.0f, 1.0f, 0.0f, 1.0f, 0.4f, 2, 0, 0.0f),
        BOOMERANG(0, 0.5f, 2.0f, 1.0f, 1.0f, 0.4f, 1, 1, 2.0f),
        NONE(0, 1.0f, 1.0f, 0.0f, 1.0f, 0.4f, 0, 0, 0.0f);

        public final int durabilityBase;
        public final float durabilityMult;
        public final float damageBase;
        public final float damageMult;
        public final float blockDamage;
        public final float knockback;
        public final float attackDelay;
        public final int dmgFromEntity;
        public final int dmgFromBlock;

        private MeleeSpecs(int durbase, float durmult, float dmgbase, float dmgmult, float blockdmg, float knockbck, int dmgfromentity, int dmgfromblock, float attackdelay) {
            this.durabilityBase = durbase;
            this.durabilityMult = durmult;
            this.damageBase = dmgbase;
            this.damageMult = dmgmult;
            this.blockDamage = blockdmg;
            this.knockback = knockbck;
            this.dmgFromEntity = dmgfromentity;
            this.dmgFromBlock = dmgfromblock;
            this.attackDelay = attackdelay;
        }

        public float getKnockBack(class_1832 material) {
            return material == class_1834.field_8929 ? this.knockback * 1.5f : this.knockback;
        }
    }
}

