/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.RangedComponent;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityBlunderShot
extends EntityProjectile {
    public static final String NAME = "shot";

    public EntityBlunderShot(World world) {
        super(world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
    }

    public EntityBlunderShot(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityBlunderShot(World world, EntityLivingBase shooter) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        this.setThrower((Entity)shooter);
    }

    public void func_184547_a(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, f3, f4);
        this.field_70159_w += entity.field_70159_w;
        this.field_70179_y += entity.field_70179_y;
        if (!entity.field_70122_E) {
            this.field_70181_x += entity.field_70181_x;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.ticksInAir > 4) {
            this.func_70106_y();
        }
    }

    @Override
    public void onHitEntity(RayTraceResult raytraceResult) {
        Entity entity = raytraceResult.field_72308_g;
        float damage = 4.0f + this.extraDamage;
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        int prevhurtrestime = entity.field_70172_ad;
        if (entity.func_70097_a(damagesource, damage)) {
            entity.field_70172_ad = prevhurtrestime;
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.func_70106_y();
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxLifetime() {
        return 200;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float getGravity() {
        return this.getTotalVelocity() < 2.0 ? 0.04f : 0.0f;
    }

    @Override
    @Nonnull
    protected ItemStack func_184550_j() {
        return new ItemStack((Item)BalkonsWeaponMod.blunderShot);
    }

    public static void fireSpreadShot(World world, EntityLivingBase entityliving, RangedComponent item, ItemStack itemstack) {
        for (int i = 0; i < 10; ++i) {
            EntityBlunderShot entity = new EntityBlunderShot(world, entityliving);
            entity.func_184547_a((Entity)entityliving, entityliving.field_70125_A, entityliving.field_70177_z, 0.0f, 5.0f, 15.0f);
            if (item != null && !itemstack.func_190926_b()) {
                item.applyProjectileEnchantments(entity, itemstack);
            }
            world.func_72838_d((Entity)entity);
        }
    }

    public static void fireFromDispenser(World world, double d, double d1, double d2, int i, int j, int k) {
        for (int i2 = 0; i2 < 10; ++i2) {
            EntityBlunderShot entityblundershot = new EntityBlunderShot(world, d, d1, d2);
            entityblundershot.func_70186_c(i, j, k, 5.0f, 15.0f);
            world.func_72838_d((Entity)entityblundershot);
        }
    }
}

