/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityCannonBall
extends EntityProjectile {
    public static final String NAME = "cannonball";

    public EntityCannonBall(World world) {
        super(world);
    }

    public EntityCannonBall(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityCannonBall(World world, EntityCannon entitycannon, float f, float f1, boolean superPowered) {
        this(world, entitycannon.field_70165_t, entitycannon.field_70163_u + 1.0, entitycannon.field_70161_v);
        Entity entityPassenger = entitycannon.func_184188_bt().isEmpty() ? null : (Entity)entitycannon.func_184188_bt().get(0);
        this.setThrower((Entity)entitycannon);
        if (entityPassenger instanceof EntityLivingBase) {
            this.setPickupStatusFromEntity((EntityLivingBase)entityPassenger);
        } else {
            this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        }
        this.func_70105_a(0.5f, 0.5f);
        float x = -MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, superPowered ? 4.0f : 2.0f, superPowered ? 0.1f : 2.0f);
        this.field_70159_w += entitycannon.field_70159_w;
        this.field_70179_y += entitycannon.field_70179_y;
        this.func_70243_d(superPowered);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        double speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        double amount = 8.0;
        if (speed > 1.0) {
            int i1 = 1;
            while ((double)i1 < amount) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + this.field_70159_w * (double)i1 / amount, this.field_70163_u + this.field_70181_x * (double)i1 / amount, this.field_70161_v + this.field_70179_y * (double)i1 / amount, 0.0, 0.0, 0.0, new int[0]);
                ++i1;
            }
        }
    }

    public void createCrater() {
        if (this.field_70170_p.field_72995_K || !this.inGround || this.func_70090_H()) {
            return;
        }
        this.func_70106_y();
        float f = this.func_70241_g() ? 5.0f : 2.5f;
        PhysHelper.createAdvancedExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, f, BalkonsWeaponMod.instance.modConfig.cannonDoesBlockDamage, true, false, false);
    }

    @Override
    public void onHitEntity(RayTraceResult raytraceResult) {
        Entity entity = raytraceResult.field_72308_g;
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        if (entity.func_70097_a(damagesource, 30.0f)) {
            this.func_184185_a(SoundEvents.field_187800_eb, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.4f + 0.7f));
        }
    }

    @Override
    public void onHitBlock(RayTraceResult raytraceResult) {
        BlockPos blockpos = raytraceResult.func_178782_a();
        this.xTile = blockpos.func_177958_n();
        this.yTile = blockpos.func_177956_o();
        this.zTile = blockpos.func_177952_p();
        this.inBlockState = this.field_70170_p.func_180495_p(blockpos);
        this.field_70159_w = raytraceResult.field_72307_f.field_72450_a - this.field_70165_t;
        this.field_70181_x = raytraceResult.field_72307_f.field_72448_b - this.field_70163_u;
        this.field_70179_y = raytraceResult.field_72307_f.field_72449_c - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.inGround = true;
        if (this.inBlockState != null) {
            this.inBlockState.func_177230_c().func_180634_a(this.field_70170_p, blockpos, this.inBlockState, (Entity)this);
        }
        this.createCrater();
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public float getGravity() {
        return 0.04f;
    }

    @Override
    @Nonnull
    public ItemStack getPickupItem() {
        return new ItemStack((Item)BalkonsWeaponMod.cannonBall, 1);
    }

    @Override
    @Nonnull
    protected ItemStack func_184550_j() {
        return new ItemStack((Item)BalkonsWeaponMod.cannonBall);
    }
}

