/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.entity.projectile.EntityFlail;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlail
extends ItemMelee {
    private final float flailDamage;

    public ItemFlail(String id, MeleeComponent meleecomponent) {
        this("weaponmod", id, meleecomponent);
    }

    public ItemFlail(String modId, String id, MeleeComponent meleecomponent) {
        super(modId, id, meleecomponent);
        this.flailDamage = 4.0f + meleecomponent.weaponMaterial.func_78000_c();
        this.func_185043_a(new ResourceLocation("weaponmod", "thrown"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn instanceof EntityPlayer && entityIn.func_184614_ca() == stack && ItemFlail.this.isThrown((EntityPlayer)entityIn) ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Override
    public void func_77663_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull Entity entity, int i, boolean flag) {
        Entity entity2;
        int id;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!this.isThrown(player)) {
            return;
        }
        ItemStack itemstack2 = player.func_184614_ca();
        if (itemstack2.func_190926_b() || !(itemstack2.func_77973_b() instanceof ItemFlail)) {
            this.setThrown(player, false);
        } else if (itemstack2.func_77973_b() == this && (id = PlayerWeaponData.getFlailEntityId(player)) != 0 && (entity2 = world.func_73045_a(id)) instanceof EntityFlail) {
            ((EntityFlail)entity2).setThrower((Entity)player);
            ((EntityFlail)entity2).setThrownItemStack(itemstack);
        }
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer entityplayer, @Nonnull EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        this.removePreviousFlail(world, entityplayer);
        entityplayer.func_184609_a(hand);
        if (!entityplayer.func_184812_l_()) {
            itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
        }
        if (!itemstack.func_190926_b()) {
            this.throwFlail(itemstack, world, entityplayer);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public boolean func_77644_a(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase entityliving, @Nonnull EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            this.func_77659_a(attacker.field_70170_p, (EntityPlayer)attacker, EnumHand.MAIN_HAND);
        }
        return true;
    }

    public void throwFlail(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        world.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!world.field_72995_K) {
            EntityFlail entityflail = new EntityFlail(world, (EntityLivingBase)entityplayer, itemstack);
            entityflail.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, 0.75f, 3.0f);
            PlayerWeaponData.setFlailEntityId(entityplayer, entityflail.func_145782_y());
            world.func_72838_d((Entity)entityflail);
            this.setThrown(entityplayer, true);
        }
    }

    public void setThrown(EntityPlayer entityplayer, boolean flag) {
        PlayerWeaponData.setFlailThrown(entityplayer, flag);
    }

    public boolean isThrown(EntityPlayer entityplayer) {
        return PlayerWeaponData.isFlailThrown(entityplayer);
    }

    private void removePreviousFlail(World world, EntityPlayer entityplayer) {
        Entity entity;
        int id = PlayerWeaponData.getFlailEntityId(entityplayer);
        if (id != 0 && (entity = world.func_73045_a(id)) instanceof EntityFlail) {
            entity.func_70106_y();
        }
    }

    public float getFlailDamage() {
        return this.flailDamage;
    }
}

