/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.item.ItemShooter;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedCompMusket;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemMusket
extends ItemShooter {
    @Nullable
    protected final Item bayonetItem;
    private final int bayonetDurability;

    public ItemMusket(String id, MeleeComponent meleecomponent, @Nullable Item bayonetitem) {
        this("weaponmod", id, meleecomponent, bayonetitem);
    }

    public ItemMusket(String modId, String id, MeleeComponent meleecomponent, @Nullable Item bayonetitem) {
        super(modId, id, new RangedCompMusket(), meleecomponent);
        this.bayonetItem = bayonetitem;
        this.bayonetDurability = meleecomponent.meleeSpecs != MeleeComponent.MeleeSpecs.NONE && meleecomponent.weaponMaterial != null ? meleecomponent.meleeSpecs.durabilityBase + (int)((float)meleecomponent.weaponMaterial.func_77997_a() * meleecomponent.meleeSpecs.durabilityMult) : 0;
    }

    public boolean hasBayonet() {
        return this.bayonetItem != null;
    }

    @Override
    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        return this.rangedComponent.canApplyEnchantment(stack, enchantment);
    }

    public void func_77624_a(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull List<String> tooltip, boolean advanced) {
        short dmg;
        super.func_77624_a(stack, player, tooltip, advanced);
        if (this.hasBayonet() && stack.func_77942_o() && stack.func_77978_p().func_150297_b("bayonetDamage", 2) && (dmg = stack.func_77978_p().func_74765_d("bayonetDamage")) != 0) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.bayonetdurability", (Object[])new Object[]{this.bayonetDurability - dmg, this.bayonetDurability}));
        }
    }

    @Override
    public boolean func_77644_a(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase entityliving, @Nonnull EntityLivingBase attacker) {
        if (this.hasBayonet()) {
            if (entityliving.field_70172_ad == entityliving.field_70771_an) {
                float kb = this.meleeComponent.getKnockBack(itemstack, entityliving, attacker);
                PhysHelper.knockBack(entityliving, attacker, kb);
                entityliving.field_70172_ad -= (int)(2.0f / this.meleeComponent.meleeSpecs.attackDelay);
            }
            if (attacker instanceof EntityPlayer && !((EntityPlayer)attacker).func_184812_l_()) {
                this.bayonetDamage(itemstack, attacker, 1);
            }
        }
        return true;
    }

    @Override
    public boolean func_179218_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull IBlockState block, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entityliving) {
        if (this.hasBayonet()) {
            boolean flag;
            Material material = block.func_185904_a();
            boolean bl = flag = material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C;
            if (entityliving instanceof EntityPlayer && !((EntityPlayer)entityliving).func_184812_l_() && flag) {
                this.bayonetDamage(itemstack, entityliving, 2);
            }
        }
        return true;
    }

    public void bayonetDamage(ItemStack itemstack, EntityLivingBase entityliving, int damage) {
        int bayonetdamage;
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if ((bayonetdamage = itemstack.func_77978_p().func_74765_d("bayonetDamage") + damage) > this.bayonetDurability) {
            entityliving.func_70669_a(itemstack);
            if (entityliving instanceof EntityPlayer) {
                ((EntityPlayer)entityliving).func_71029_a(StatList.func_188059_c((Item)this));
            }
            bayonetdamage = 0;
            ItemStack itemstack2 = new ItemStack((Item)BalkonsWeaponMod.musket, 1);
            itemstack2.func_77964_b(itemstack.func_77952_i());
            entityliving.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack2);
            if (itemstack.func_77978_p().func_74764_b("rld")) {
                ReloadHelper.setReloadState(itemstack2, ReloadHelper.getReloadState(itemstack));
            }
        }
        itemstack.func_77978_p().func_74777_a("bayonetDamage", (short)bayonetdamage);
    }
}

