/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WarhammerExplosion;
import ckathode.weaponmod.item.MeleeComponent;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MeleeCompWarhammer
extends MeleeComponent {
    public static final int CHARGE_DELAY = 400;

    public MeleeCompWarhammer(Item.ToolMaterial toolmaterial) {
        super(MeleeComponent.MeleeSpecs.WARHAMMER, toolmaterial);
    }

    @Override
    public float getBlockDamage(ItemStack itemstack, IBlockState block) {
        float f = super.getBlockDamage(itemstack, block);
        float f2 = this.weaponMaterial.func_78000_c() + 2.0f;
        return f * f2;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityLivingBase entityliving, int i) {
        int j = this.getMaxItemUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 4.0f) > 1.0f) {
            this.superSmash(itemstack, world, entityliving);
        }
    }

    protected void superSmash(ItemStack itemstack, World world, EntityLivingBase entityLiving) {
        entityLiving.func_184609_a(EnumHand.MAIN_HAND);
        float f = this.getEntityDamage() / 2.0f;
        WarhammerExplosion expl = new WarhammerExplosion(world, (Entity)entityLiving, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, f, false, true);
        DamageSource source = entityLiving instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entityLiving)) : DamageSource.func_76358_a((EntityLivingBase)entityLiving);
        expl.doEntityExplosion(source);
        expl.doParticleExplosion(true, false);
        PhysHelper.sendExplosion(world, expl, true, false);
        itemstack.func_77972_a(16, entityLiving);
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_71020_j(6.0f);
            this.setSmashed((EntityPlayer)entityLiving);
        }
    }

    public void setSmashed(EntityPlayer entityplayer) {
        PlayerWeaponData.setLastWarhammerSmashTicks(entityplayer, entityplayer.field_70173_aa);
    }

    public boolean isCharged(EntityPlayer entityplayer) {
        return this.getCooldown(entityplayer) <= 0;
    }

    public float getScaledCooldown(EntityPlayer entityplayer) {
        return (float)this.getCooldown(entityplayer) / 400.0f;
    }

    public int getCooldown(EntityPlayer entityplayer) {
        return PlayerWeaponData.getLastWarhammerSmashTicks(entityplayer) + 400 - entityplayer.field_70173_aa;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.BOW;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer, EnumHand hand) {
        if (itemstack.func_190926_b()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        if (this.isCharged(entityplayer)) {
            entityplayer.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderCooldown() {
        return !this.isCharged((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getCooldown() {
        return this.getScaledCooldown((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }
}

