/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.Nullable;

public class WMItem
extends Item {
    public WMItem(String id) {
        this("weaponmod", id);
    }

    public WMItem(String modId, String id) {
        this.setRegistryName(new ResourceLocation(modId, id));
        this.func_77655_b(id);
        this.func_77637_a(CreativeTabs.field_78037_j);
    }

    public static UUID getAttackDamageModifierUUID() {
        return Item.field_111210_e;
    }

    public static UUID getAttackSpeedModifierUUID() {
        return Item.field_185050_h;
    }

    public static void decrStackSize(ItemStack stack, int amount, EntityLivingBase entity) {
        stack.func_77979_a(amount);
        if (stack.func_190926_b() && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, stack, player.field_184622_au));
        }
    }

    public static boolean isItemInList(ItemStack stack, Collection<Item> items) {
        return stack != null && items.contains(stack.func_77973_b());
    }

    @Nullable
    public static Tuple<EnumHand, Integer> findAnyItemSlot(EntityPlayer player, Collection<Item> item) {
        if (WMItem.isItemInList(player.func_184614_ca(), item)) {
            return new Tuple((Object)EnumHand.MAIN_HAND, (Object)player.field_71071_by.field_70461_c);
        }
        if (WMItem.isItemInList(player.func_184592_cb(), item)) {
            return new Tuple((Object)EnumHand.OFF_HAND, (Object)0);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!WMItem.isItemInList(itemstack, item)) continue;
            return new Tuple((Object)EnumHand.MAIN_HAND, (Object)i);
        }
        return null;
    }

    public static boolean consumeInventoryItem(EntityPlayer player, Item item) {
        return WMItem.consumeAnyInventoryItem(player, Collections.singletonList(item));
    }

    public static boolean consumeAnyInventoryItem(EntityPlayer player, Collection<Item> item) {
        Tuple<EnumHand, Integer> slot = WMItem.findAnyItemSlot(player, item);
        if (slot == null) {
            return false;
        }
        NonNullList inv = slot.func_76341_a() == EnumHand.OFF_HAND ? player.field_71071_by.field_184439_c : player.field_71071_by.field_70462_a;
        ((ItemStack)inv.get(((Integer)slot.func_76340_b()).intValue())).func_77979_a(1);
        return true;
    }
}

