/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.entity.projectile.EntityCannonBall;
import ckathode.weaponmod.item.WMItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityCannon
extends EntityBoat {
    public static final String NAME = "cannon";
    private static final int TIME_SINCE_HIT = 20;
    private static final int ROCK_DIRECTION = 21;
    private static final int CURRENT_DAMAGE = 22;
    private static final int LOADED = 23;
    private static final int LOAD_TIMER = 24;
    private static final int SUPER_POWERED = 25;

    public EntityCannon(World world) {
        super(world);
        this.field_70156_m = true;
        this.field_70125_A = -20.0f;
        this.field_70177_z = -180.0f;
        this.func_70101_b(-180.0f, this.field_70125_A);
        this.func_70105_a(1.5f, 1.0f);
    }

    public EntityCannon(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)1);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return 0.35;
    }

    public boolean func_70097_a(@Nonnull DamageSource damagesource, float damage) {
        EntityPlayer player;
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (damagesource instanceof EntityDamageSourceIndirect && damagesource.func_76364_f() != null) {
            if (damagesource.func_76364_f() == this.field_70153_n) {
                return true;
            }
        } else if (damagesource instanceof EntityDamageSource && damagesource.field_76373_n.equals("player") && damagesource.func_76364_f() instanceof EntityPlayer && (player = (EntityPlayer)damagesource.func_76364_f()) != null && player.field_71071_by.func_70448_g() == null) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_145779_a(BalkonsWeaponMod.cannon, 1);
                if (this.isLoaded() || this.isLoading()) {
                    this.func_145779_a(BalkonsWeaponMod.cannonBall, 1);
                    this.func_145779_a(Items.field_151016_H, 1);
                }
            }
            this.func_70106_y();
            return true;
        }
        this.setRockDirection(-this.getRockDirection());
        this.func_70265_b(10);
        this.setCurrentDamage(this.getCurrentDamage() + (int)damage * 5);
        this.func_70018_K();
        if (this.getCurrentDamage() > 100) {
            for (int j = 0; j < 6; ++j) {
                this.dropItemWithChance(Items.field_151042_j, (int)damage, 1);
            }
            this.dropItemWithChance(Items.field_151145_ak, (int)damage, 1);
            this.dropItemWithChance(Item.func_150898_a((Block)Blocks.field_150364_r), (int)damage, 1);
            if (this.isLoaded() || this.isLoading()) {
                this.func_145779_a(BalkonsWeaponMod.cannonBall, 1);
                this.func_145779_a(Items.field_151016_H, 1);
            }
            this.func_70106_y();
        }
        return true;
    }

    public void dropItemWithChance(Item item, int chance, int amount) {
        if (this.field_70146_Z.nextInt(chance) < 10) {
            this.func_145779_a(item, amount);
        }
    }

    public void func_70057_ab() {
        this.setRockDirection(-this.getRockDirection());
        this.func_70265_b(10);
        this.setCurrentDamage(this.getCurrentDamage() + 10);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        super.func_70030_z();
        int i = this.func_70268_h();
        if (i > 0) {
            this.func_70265_b(i - 1);
        }
        if ((i = this.getCurrentDamage()) > 0) {
            this.setCurrentDamage(i - this.field_70146_Z.nextInt(2));
        }
        this.field_70181_x -= 0.1;
        if (this.field_70122_E) {
            this.field_70159_w *= 0.1;
            this.field_70179_y *= 0.1;
        }
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        if (!this.field_70122_E) {
            this.field_70143_R += (float)(-this.field_70181_x);
        }
        if (this.field_70153_n != null) {
            float yaw = this.field_70153_n.field_70177_z;
            float pitch = this.field_70153_n.field_70125_A;
            this.field_70177_z = yaw % 360.0f;
            this.field_70125_A = pitch;
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity == this.field_70153_n || !entity.func_70104_M()) continue;
                this.func_70108_f(entity);
            }
        }
        if (this.isLoading()) {
            this.setLoadTimer(this.getLoadTimer() - 1);
            this.handleReloadTime();
        }
    }

    public void func_180430_e(float f, float f1) {
        super.func_180430_e(f, f1);
        int i = MathHelper.func_76141_d((float)f);
        this.func_70097_a(DamageSource.field_76379_h, i *= 2);
    }

    protected void func_180433_a(double y, boolean isOnGround, Block blockIn, BlockPos pos) {
        if (isOnGround) {
            if (this.field_70143_R > 3.0f) {
                this.func_180430_e(this.field_70143_R, 1.0f);
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.func_70106_y();
                    if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                        for (int j = 0; j < 5; ++j) {
                            this.func_145778_a(Items.field_151042_j, 1, 0.0f);
                        }
                        this.func_145778_a(Items.field_151145_ak, 1, 0.0f);
                        this.func_145778_a(Item.func_150898_a((Block)Blocks.field_150364_r), 1, 0.0f);
                        if (this.isLoaded() || this.isLoading()) {
                            this.func_145778_a(BalkonsWeaponMod.cannonBall, 1, 0.0f);
                            this.func_145778_a(Items.field_151016_H, 1, 0.0f);
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            }
        } else if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_177230_c().func_149688_o() != Material.field_151586_h && y < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - y);
        }
    }

    public void handleReloadTime() {
        int l = this.getLoadTimer();
        if (l > 0) {
            if (l == 80 || l == 70 || l == 60) {
                this.field_70170_p.func_72956_a((Entity)this, "tile.piston.in", 0.5f, 1.2f / (this.field_70146_Z.nextFloat() * 0.8f + 0.6f));
            } else if (l == 40) {
                this.field_70170_p.func_72956_a((Entity)this, "random.breath", 0.7f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 10.0f));
            }
        } else {
            this.setReloadInfo(true, 0);
        }
    }

    public void fireCannon() {
        if (!this.isLoaded()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityCannonBall entitycannonball = new EntityCannonBall(this.field_70170_p, this, this.field_70153_n.field_70125_A, this.field_70153_n.field_70177_z, this.isSuperPowered());
            this.field_70170_p.func_72838_d((Entity)entitycannonball);
        }
        this.setReloadInfo(false, 0);
        this.fireEffects();
    }

    public void fireEffects() {
        this.field_70170_p.func_72956_a((Entity)this, "random.explode", 8.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.8f + 0.9f));
        this.field_70170_p.func_72956_a((Entity)this, "ambient.weather.thunder", 8.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.6f));
        float yaw = (float)Math.toRadians(this.field_70177_z);
        double d = -MathHelper.func_76126_a((float)yaw) * -1.0f;
        double d2 = MathHelper.func_76134_b((float)yaw) * -1.0f;
        for (int i = 0; i < 20; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + d + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70163_u + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v + d2 + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70146_Z.nextDouble() * 0.1 - 0.05, this.field_70146_Z.nextDouble() * 0.1 - 0.05, this.field_70146_Z.nextDouble() * 0.1 - 0.05, new int[0]);
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70125_A += 10.0f;
        }
        this.func_70097_a(DamageSource.field_76377_j, 2.0f);
    }

    public void setReloadInfo(boolean loaded, int reloadtime) {
        this.setLoaded(loaded);
        this.setLoadTimer(reloadtime);
    }

    public void startLoadingCannon() {
        if (this.isLoaded() && !this.isLoading()) {
            return;
        }
        this.setReloadInfo(false, 100);
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            float f = -0.85f;
            float f2 = (float)((this.field_70128_L ? 0.01 : this.func_70042_X()) + this.field_70153_n.func_70033_W());
            Vec3 vec3d = new Vec3((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            this.field_70153_n.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f2, this.field_70161_v + vec3d.field_72449_c);
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74776_a("falld", this.field_70143_R);
        nbttagcompound.func_74757_a("load", this.isLoaded());
        nbttagcompound.func_74777_a("ldtime", (short)this.getLoadTimer());
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70143_R = nbttagcompound.func_74760_g("falld");
        this.setLoaded(nbttagcompound.func_74767_n("load"));
        this.setLoadTimer(nbttagcompound.func_74765_d("ldtime"));
    }

    public boolean func_130002_c(@Nonnull EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.func_71045_bC();
        if (itemstack != null && itemstack.func_77973_b() == BalkonsWeaponMod.cannonBall && !this.isLoaded() && !this.isLoading() && (entityplayer.field_71075_bZ.field_75098_d || this.consumeAmmo(entityplayer, Items.field_151016_H))) {
            if (entityplayer.field_71075_bZ.field_75098_d || this.consumeAmmo(entityplayer, BalkonsWeaponMod.cannonBall)) {
                this.startLoadingCannon();
                return true;
            }
            this.func_145779_a(Items.field_151016_H, 1);
        } else {
            if (this.field_70153_n != null && this.riddenByPlayer() && this.notThisPlayer((Entity)entityplayer)) {
                return true;
            }
            if (!this.field_70170_p.field_72995_K && !entityplayer.func_70093_af()) {
                entityplayer.func_70078_a((Entity)this);
            }
        }
        return true;
    }

    protected boolean consumeAmmo(EntityPlayer entityplayer, Item itemAmmo) {
        return WMItem.consumeInventoryItem(entityplayer, itemAmmo);
    }

    public boolean riddenByPlayer() {
        Entity entity = this.field_70153_n;
        return entity instanceof EntityPlayer;
    }

    public boolean notThisPlayer(Entity player) {
        Entity entity = this.field_70153_n;
        return entity != player;
    }

    public void func_70077_a(@Nonnull EntityLightningBolt entitylightningbolt) {
        this.func_70097_a(DamageSource.field_180137_b, 100.0f);
        this.setSuperPowered(true);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack((Item)BalkonsWeaponMod.cannon);
    }

    public void setLoaded(boolean flag) {
        this.field_70180_af.func_75692_b(23, (Object)((byte)(flag ? 1 : 0)));
    }

    public void setLoadTimer(int time) {
        this.field_70180_af.func_75692_b(24, (Object)time);
    }

    public void setSuperPowered(boolean flag) {
        this.field_70180_af.func_75692_b(25, (Object)((byte)(flag ? 1 : 0)));
    }

    public boolean isLoading() {
        return this.getLoadTimer() > 0;
    }

    public boolean isLoaded() {
        return this.field_70180_af.func_75683_a(23) != 0;
    }

    public int getLoadTimer() {
        return this.field_70180_af.func_75679_c(24);
    }

    public boolean isSuperPowered() {
        return this.field_70180_af.func_75683_a(25) != 0;
    }

    public void func_70265_b(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public void setRockDirection(int i) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)i));
    }

    public void setCurrentDamage(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    public int func_70268_h() {
        return this.field_70180_af.func_75679_c(20);
    }

    public int getRockDirection() {
        return this.field_70180_af.func_75683_a(21);
    }

    public int getCurrentDamage() {
        return this.field_70180_af.func_75679_c(22);
    }
}

