/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemVariants;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShooter
extends ItemBow
implements IItemWeapon {
    protected static final int MAX_DELAY = 72000;
    public final RangedComponent rangedComponent;
    public final MeleeComponent meleeComponent;
    public final String rawId;
    private final ModelResourceLocation loadedModel;
    private Boolean loadedModelExists;

    public ItemShooter(String id, RangedComponent rangedcomponent, MeleeComponent meleecomponent) {
        this("weaponmod", id, rangedcomponent, meleecomponent);
    }

    public ItemShooter(String modId, String id, RangedComponent rangedcomponent, MeleeComponent meleecomponent) {
        this.rawId = id;
        this.setRegistryName(new ResourceLocation(modId, id));
        this.func_77655_b(id);
        this.rangedComponent = rangedcomponent;
        this.meleeComponent = meleecomponent;
        rangedcomponent.setItem(this);
        meleecomponent.setItem(this);
        rangedcomponent.setThisItemProperties();
        this.loadedModel = new ModelResourceLocation(new ResourceLocation(modId, this.rawId + "-loaded"), "inventory");
        this.loadedModelExists = null;
    }

    public float func_150893_a(ItemStack itemstack, Block block) {
        return this.meleeComponent.getBlockDamage(itemstack, block);
    }

    public boolean func_150897_b(Block block) {
        return this.meleeComponent.canHarvestBlock(block);
    }

    public boolean func_77644_a(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase entityliving, @Nonnull EntityLivingBase attacker) {
        return this.meleeComponent.hitEntity(itemstack, entityliving, attacker);
    }

    public boolean func_179218_a(ItemStack itemstack, World world, Block block, BlockPos pos, EntityLivingBase entityliving) {
        return this.meleeComponent.onBlockDestroyed(itemstack, world, block, pos, entityliving);
    }

    public int func_77619_b() {
        return this.meleeComponent.getItemEnchantability();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        this.meleeComponent.addItemAttributeModifiers((Multimap<String, AttributeModifier>)multimap);
        this.rangedComponent.addItemAttributeModifiers((Multimap<String, AttributeModifier>)multimap);
        return multimap;
    }

    @Override
    public boolean onLeftClickEntity(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull Entity entity) {
        return this.meleeComponent.onLeftClickEntity(itemstack, player, entity) && this.rangedComponent.onLeftClickEntity(itemstack, player, entity);
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack itemstack) {
        return this.rangedComponent.getItemUseAction(itemstack);
    }

    public int func_77626_a(@Nonnull ItemStack itemstack) {
        return this.rangedComponent.getMaxItemUseDuration(itemstack);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        return this.rangedComponent.onItemRightClick(worldIn, playerIn, itemStackIn);
    }

    public void onUsingTick(ItemStack itemstack, EntityPlayer entityplayer, int count) {
        this.rangedComponent.onUsingTick(itemstack, (EntityLivingBase)entityplayer, count);
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        this.rangedComponent.onPlayerStoppedUsing(itemstack, world, (EntityLivingBase)entityplayer, i);
    }

    public void func_77663_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull Entity entity, int i, boolean flag) {
        this.meleeComponent.onUpdate(itemstack, world, entity, i, flag);
        this.rangedComponent.onUpdate(itemstack, world, entity, i, flag);
    }

    @Override
    public Random getItemRand() {
        return field_77697_d;
    }

    @Override
    public MeleeComponent getMeleeComponent() {
        return this.meleeComponent;
    }

    @Override
    public RangedComponent getRangedComponent() {
        return this.rangedComponent;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        if (this.loadedModelExists == null) {
            this.loadedModelExists = WMItemVariants.itemVariantExists(this.loadedModel);
        }
        if (this.loadedModelExists.booleanValue() && RangedComponent.isReloaded(stack)) {
            return this.loadedModel;
        }
        return super.getModel(stack, player, useRemaining);
    }
}

