/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.WMItem;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class RangedComponent
extends AbstractWeaponComponent {
    protected static final int MAX_DELAY = 72000;
    public final RangedSpecs rangedSpecs;

    public static boolean isReloaded(ItemStack itemstack) {
        return ReloadHelper.getReloadState(itemstack).isReloaded();
    }

    public static boolean isReadyToFire(ItemStack itemstack) {
        return ReloadHelper.getReloadState(itemstack) == ReloadHelper.ReloadState.STATE_READY;
    }

    public static void setReloadState(ItemStack itemstack, ReloadHelper.ReloadState state) {
        ReloadHelper.setReloadState(itemstack, state);
    }

    public RangedComponent(RangedSpecs rangedspecs) {
        this.rangedSpecs = rangedspecs;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public void setThisItemProperties() {
        this.item.func_77656_e(this.rangedSpecs.durability);
    }

    @Override
    public float getEntityDamageMaterialPart() {
        return 0.0f;
    }

    @Override
    public float getEntityDamage() {
        return 0.0f;
    }

    @Override
    public float getBlockDamage(ItemStack itemstack, Block block) {
        return 0.0f;
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        return false;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, World world, Block block, BlockPos pos, EntityLivingBase entityliving) {
        return false;
    }

    @Override
    public boolean hitEntity(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return false;
    }

    @Override
    public float getAttackDelay(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return 0.0f;
    }

    @Override
    public float getKnockBack(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return 0.0f;
    }

    @Override
    public int getItemEnchantability() {
        return 1;
    }

    @Override
    public void addItemAttributeModifiers(Multimap<String, AttributeModifier> multimap) {
        multimap.put((Object)WeaponModAttributes.RELOAD_TIME.func_111108_a(), (Object)new AttributeModifier(IItemWeapon.RELOAD_TIME_MODIFIER, "Weapon reloadtime modifier", (double)this.rangedSpecs.getReloadTime(), 0));
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer player, Entity entity) {
        return false;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        ReloadHelper.ReloadState state = ReloadHelper.getReloadState(itemstack);
        if (state == ReloadHelper.ReloadState.STATE_NONE) {
            return EnumAction.BLOCK;
        }
        if (state == ReloadHelper.ReloadState.STATE_READY) {
            return EnumAction.BOW;
        }
        return EnumAction.NONE;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public ItemStack onItemRightClick(World world, EntityPlayer entityplayer, ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0 || entityplayer.func_71039_bw()) {
            return itemstack;
        }
        if (!this.hasAmmo(itemstack, world, entityplayer)) {
            this.soundEmpty(itemstack, world, entityplayer);
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
            return itemstack;
        }
        if (RangedComponent.isReadyToFire(itemstack)) {
            this.soundCharge(itemstack, world, entityplayer);
            entityplayer.func_71008_a(itemstack, this.getMaxItemUseDuration(itemstack));
            return itemstack;
        }
        entityplayer.func_71008_a(itemstack, this.getMaxItemUseDuration(itemstack));
        return itemstack;
    }

    @Override
    public void onUsingTick(ItemStack itemstack, EntityLivingBase entityliving, int count) {
        if (ReloadHelper.getReloadState(itemstack) == ReloadHelper.ReloadState.STATE_NONE && this.getMaxItemUseDuration(itemstack) - count >= this.getReloadDuration(itemstack)) {
            this.effectReloadDone(itemstack, entityliving.field_70170_p, entityliving);
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_RELOADED);
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityLivingBase entityliving, int i) {
        if (!RangedComponent.isReloaded(itemstack)) {
            return;
        }
        if (RangedComponent.isReadyToFire(itemstack)) {
            if (this.hasAmmoAndConsume(itemstack, world, entityliving)) {
                this.fire(itemstack, world, entityliving, i);
            }
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
        } else {
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_READY);
        }
    }

    @Override
    public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
    }

    public void soundEmpty(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        world.func_72956_a((Entity)entityplayer, "random.click", 1.0f, 1.25f);
    }

    public void soundCharge(ItemStack itemstack, World world, EntityPlayer entityplayer) {
    }

    public void postShootingEffects(ItemStack itemstack, EntityLivingBase entityLiving, World world) {
        if (entityLiving instanceof EntityPlayer) {
            this.effectPlayer(itemstack, (EntityPlayer)entityLiving, world);
        }
        this.effectShoot(world, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, entityLiving.field_70177_z, entityLiving.field_70125_A);
    }

    public abstract void effectReloadDone(ItemStack var1, World var2, EntityLivingBase var3);

    public abstract void fire(ItemStack var1, World var2, EntityLivingBase var3, int var4);

    public abstract void effectPlayer(ItemStack var1, EntityPlayer var2, World var3);

    public abstract void effectShoot(World var1, double var2, double var4, double var6, float var8, float var9);

    public void applyProjectileEnchantments(EntityProjectile entity, ItemStack itemstack) {
        int knockback;
        int damage;
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemstack) > 0) {
            entity.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        }
        if ((damage = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)itemstack)) > 0) {
            entity.setExtraDamage(damage);
        }
        if ((knockback = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)itemstack)) > 0) {
            entity.func_70240_a(knockback);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)itemstack) > 0) {
            entity.func_70015_d(100);
        }
    }

    public int getReloadDuration(ItemStack itemstack) {
        return this.rangedSpecs.getReloadTime();
    }

    public List<Item> getAmmoItems() {
        return this.rangedSpecs.getAmmoItems();
    }

    protected ItemStack findAmmo(EntityPlayer entityplayer) {
        int slot = WMItem.findAnyItemSlot(entityplayer, this.getAmmoItems());
        if (slot < 0) {
            return null;
        }
        return entityplayer.field_71071_by.field_70462_a[slot];
    }

    protected boolean consumeAmmo(EntityPlayer entityplayer) {
        return WMItem.consumeAnyInventoryItem(entityplayer, this.getAmmoItems());
    }

    public boolean hasAmmoAndConsume(ItemStack itemstack, World world, EntityLivingBase entityliving) {
        if (!(entityliving instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer entityplayer = (EntityPlayer)entityliving;
        return entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemstack) > 0 || this.consumeAmmo(entityplayer);
    }

    public boolean hasAmmo(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        boolean flag = this.findAmmo(entityplayer) != null;
        return entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemstack) > 0 || flag;
    }

    public float getFOVMultiplier(int ticksinuse) {
        float f1 = (float)ticksinuse / this.getMaxAimTimeTicks();
        f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
        return 1.0f - f1 * this.getMaxZoom();
    }

    protected float getMaxAimTimeTicks() {
        return 20.0f;
    }

    protected float getMaxZoom() {
        return 0.15f;
    }

    public static enum RangedSpecs {
        BLOWGUN("blowgun", 250, new ResourceLocation("weaponmod", "dart").toString()),
        CROSSBOW("crossbow", 250, new ResourceLocation("weaponmod", "bolt").toString()),
        MUSKET("musket", 80, new ResourceLocation("weaponmod", "bullet").toString()),
        BLUNDERBUSS("blunderbuss", 80, new ResourceLocation("weaponmod", "shot").toString()),
        FLINTLOCK("flintlock", 8, new ResourceLocation("weaponmod", "bullet").toString()),
        MORTAR("mortar", 40, new ResourceLocation("weaponmod", "shell").toString());

        private int reloadTime;
        private List<Item> ammoItems;
        private final String[] ammoItemTags;
        public final String reloadTimeTag;
        public final int durability;

        private RangedSpecs(String reloadtimetag, int durability, String ... ammoitemtags) {
            this.ammoItemTags = ammoitemtags;
            this.reloadTimeTag = reloadtimetag;
            this.durability = durability;
            this.ammoItems = null;
            this.reloadTime = -1;
        }

        public int getReloadTime() {
            if (this.reloadTime < 0 && BalkonsWeaponMod.instance != null) {
                this.reloadTime = BalkonsWeaponMod.instance.modConfig.getReloadTime(this.reloadTimeTag);
                BalkonsWeaponMod.modLog.debug("Found reload time {} for {} @{}", new Object[]{this.reloadTime, this.reloadTimeTag, this});
            }
            return this.reloadTime;
        }

        public List<Item> getAmmoItems() {
            if (this.ammoItems == null) {
                this.ammoItems = Arrays.stream(this.ammoItemTags).map(t -> (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(t))).filter(Objects::nonNull).collect(Collectors.toList());
                BalkonsWeaponMod.modLog.debug("Found items {} for {} @{}", new Object[]{this.ammoItems, Arrays.toString(this.ammoItemTags), this});
            }
            return this.ammoItems;
        }
    }
}

