/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.entity.projectile.MaterialRegistry;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.ItemHitEffect;
import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMaterialProjectile
extends EntityProjectile {
    private static final DataParameter<Integer> WEAPON_MATERIAL = EntityDataManager.func_187226_a(EntityMaterialProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<ItemStack>> WEAPON_ITEM = EntityDataManager.func_187226_a(EntityMaterialProjectile.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final float[][] MATERIAL_COLORS = new float[][]{{0.6f, 0.4f, 0.1f}, {0.5f, 0.5f, 0.5f}, {1.0f, 1.0f, 1.0f}, {0.0f, 0.8f, 0.7f}, {1.0f, 0.9f, 0.0f}};

    public EntityMaterialProjectile(World world) {
        super(world);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WEAPON_MATERIAL, (Object)0);
        this.field_70180_af.func_187214_a(WEAPON_ITEM, (Object)Optional.absent());
    }

    @Override
    public void writeSpawnData(ByteBuf buf) {
        super.writeSpawnData(buf);
        buf.writeInt(this.getWeaponMaterialId());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)this.getWeapon().orNull()));
    }

    @Override
    public void readSpawnData(ByteBuf buf) {
        super.readSpawnData(buf);
        this.field_70180_af.func_187227_b(WEAPON_MATERIAL, (Object)buf.readInt());
        this.field_70180_af.func_187227_b(WEAPON_ITEM, (Object)Optional.fromNullable((Object)ByteBufUtils.readItemStack((ByteBuf)buf)));
    }

    public float getMeleeHitDamage(Entity entity) {
        if (this.field_70250_c instanceof EntityLivingBase && entity instanceof EntityLivingBase) {
            return EnchantmentHelper.func_152377_a((ItemStack)((EntityLivingBase)this.field_70250_c).func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entity).func_70668_bt());
        }
        return 0.0f;
    }

    @Override
    public void onHitEntity(RayTraceResult raytraceResult) {
        super.onHitEntity(raytraceResult);
        ItemStack thrownItem = (ItemStack)this.getWeapon().orNull();
        if (thrownItem != null && thrownItem.func_77973_b() instanceof ItemHitEffect) {
            ((ItemHitEffect)thrownItem.func_77973_b()).onHitEntity(this, raytraceResult);
        }
    }

    @Override
    public void onHitBlock(RayTraceResult raytraceResult) {
        super.onHitBlock(raytraceResult);
        ItemStack thrownItem = (ItemStack)this.getWeapon().orNull();
        if (thrownItem != null && thrownItem.func_77973_b() instanceof ItemHitEffect) {
            ((ItemHitEffect)thrownItem.func_77973_b()).onHitBlock(this, raytraceResult);
        }
    }

    @Override
    public void applyEntityHitEffects(Entity entity) {
        super.applyEntityHitEffects(entity);
        if (this.field_70250_c instanceof EntityLivingBase && entity instanceof EntityLivingBase) {
            int i = EnchantmentHelper.func_77501_a((EntityLivingBase)((EntityLivingBase)this.field_70250_c));
            if (i != 0) {
                ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)i * 0.4f, (double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            }
            if ((i = EnchantmentHelper.func_90036_a((EntityLivingBase)((EntityLivingBase)this.field_70250_c))) > 0 && !entity.func_70027_ad()) {
                entity.func_70015_d(1);
            }
        }
    }

    public void setThrownItemStack(@Nullable ItemStack itemstack) {
        this.field_70180_af.func_187227_b(WEAPON_ITEM, (Object)Optional.fromNullable((Object)itemstack));
        this.updateWeaponMaterial();
    }

    @Override
    @Nullable
    public ItemStack getPickupItem() {
        return (ItemStack)this.getWeapon().orNull();
    }

    @Override
    @Nonnull
    protected ItemStack func_184550_j() {
        return (ItemStack)this.getWeapon().or((Object)super.func_184550_j());
    }

    public int getWeaponMaterialId() {
        return (Integer)this.field_70180_af.func_187225_a(WEAPON_MATERIAL);
    }

    public Optional<ItemStack> getWeapon() {
        return (Optional)this.field_70180_af.func_187225_a(WEAPON_ITEM);
    }

    protected void updateWeaponMaterial() {
        ItemStack thrownItem = (ItemStack)this.getWeapon().orNull();
        if (thrownItem != null && thrownItem.func_77973_b() instanceof IItemWeapon && ((IItemWeapon)thrownItem.func_77973_b()).getMeleeComponent() != null) {
            int material = MaterialRegistry.getMaterialID(thrownItem);
            if (material < 0) {
                material = ((IItemWeapon)thrownItem.func_77973_b()).getMeleeComponent().weaponMaterial.ordinal();
            }
            this.field_70180_af.func_187227_b(WEAPON_MATERIAL, (Object)material);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getMaterialColor() {
        int id = this.getWeaponMaterialId();
        if (id >= 0 && id < MATERIAL_COLORS.length) {
            return MATERIAL_COLORS[id];
        }
        return MaterialRegistry.getColorFromMaterialID(id);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        ItemStack thrownItem = (ItemStack)this.getWeapon().orNull();
        if (thrownItem != null) {
            nbttagcompound.func_74782_a("thrI", (NBTBase)thrownItem.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("thrI")) {
            this.setThrownItemStack(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("thrI")));
        }
    }
}

