/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.WMUtil;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AdvancedExplosion
extends ServerExplosion {
    protected static final Random rand = new Random();
    public final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    public final ServerLevel serverLevel;
    public final DamageSource damageSource;
    public final Vec3 center;
    public final Entity exploder;
    public final float explosionSize;
    protected boolean blocksCalculated;

    public AdvancedExplosion(ServerLevel world, Entity entity, Vec3 position, float size, boolean flame, Explosion.BlockInteraction mode) {
        this(world, entity, null, null, position, size, flame, mode);
    }

    public AdvancedExplosion(ServerLevel world, Entity entity, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator calculator, Vec3 position, float size, boolean flame, Explosion.BlockInteraction mode) {
        super(world, entity, source, calculator, position, size, flame, mode);
        this.serverLevel = world;
        this.damageSource = world.damageSources().explosion((Explosion)this);
        this.exploder = entity;
        this.center = position;
        this.explosionSize = size;
    }

    public void setAffectedBlockPositions(List<BlockPos> list) {
        this.toBlow.addAll(list);
        this.blocksCalculated = true;
    }

    public void doEntityExplosion() {
        this.doEntityExplosion(this.damageSource);
    }

    public void doEntityExplosion(DamageSource damagesource) {
        float size = this.explosionSize * 2.0f;
        int k1 = Mth.floor((double)(this.center.x - (double)size - 1.0));
        int l1 = Mth.floor((double)(this.center.x + (double)size + 1.0));
        int i2 = Mth.floor((double)(this.center.y - (double)size - 1.0));
        int i3 = Mth.floor((double)(this.center.y + (double)size + 1.0));
        int j2 = Mth.floor((double)(this.center.z - (double)size - 1.0));
        int j3 = Mth.floor((double)(this.center.z + (double)size + 1.0));
        List list = this.serverLevel.getEntities(this.exploder, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i3, (double)j3));
        for (Entity entity : list) {
            Vec3 d;
            double dr;
            if (entity.ignoreExplosion((Explosion)this) || !((dr = Math.sqrt(entity.distanceToSqr(this.center)) / (double)size) <= 1.0) || (d = entity.position().subtract(this.center)).lengthSqr() == 0.0) continue;
            d = d.normalize();
            double dens = AdvancedExplosion.getSeenPercent((Vec3)this.center, (Entity)entity);
            double var36 = (1.0 - dr) * dens;
            int damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)size + 1.0);
            entity.hurtServer(this.serverLevel, damagesource, (float)damage);
            entity.setDeltaMovement(entity.getDeltaMovement().add(d.x * var36, d.y * var36, d.z * var36));
        }
    }

    public void doBlockExplosion() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        ObjectArrayList positions = new ObjectArrayList(this.toBlow);
        ArrayList list = new ArrayList();
        Util.shuffle((List)positions, (RandomSource)WMUtil.RANDOM);
        for (BlockPos blockPos2 : positions) {
            this.serverLevel.getBlockState(blockPos2).onExplosionHit(this.serverLevel, blockPos2, (Explosion)this, (itemStack, blockPos) -> ServerExplosion.addOrAppendStack((List)list, (ItemStack)itemStack, (BlockPos)blockPos));
        }
        for (ServerExplosion.StackCollector collector : list) {
            Block.popResource((Level)this.serverLevel, (BlockPos)collector.pos, (ItemStack)collector.stack);
        }
    }

    public void doFlaming() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (BlockPos blockpos : this.toBlow) {
            if (rand.nextInt(3) != 0 || !this.serverLevel.getBlockState(blockpos).isAir() || !this.serverLevel.getBlockState(blockpos.below()).isSolidRender()) continue;
            this.serverLevel.setBlockAndUpdate(blockpos, BaseFireBlock.getState((BlockGetter)this.serverLevel, (BlockPos)blockpos));
        }
    }

    public void doParticleExplosion(boolean smallparticles, boolean bigparticles) {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        AdvancedExplosion.doParticleExplosion((Level)this.serverLevel, this.center, this.toBlow, this.explosionSize, smallparticles, bigparticles);
    }

    public static void doParticleExplosion(Level level, Vec3 center, Collection<BlockPos> toBlow, float explosionSize, boolean smallparticles, boolean bigparticles) {
        level.playSound(null, center.x, center.y, center.z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (WMUtil.RANDOM.nextFloat() - WMUtil.RANDOM.nextFloat()) * 0.2f) * 0.7f);
        if (bigparticles && level.isClientSide()) {
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, center.x, center.y, center.z, 0.0, 0.0, 0.0);
        }
        if (!smallparticles) {
            return;
        }
        for (BlockPos blockpos : toBlow) {
            double px = (float)blockpos.getX() + WMUtil.RANDOM.nextFloat();
            double py = (float)blockpos.getY() + WMUtil.RANDOM.nextFloat();
            double pz = (float)blockpos.getZ() + WMUtil.RANDOM.nextFloat();
            double dx = px - center.x;
            double dy = py - center.y;
            double dz = pz - center.z;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            dx /= distance;
            dy /= distance;
            dz /= distance;
            double d7 = 0.5 / (distance / (double)explosionSize + 0.1);
            dx *= (d7 *= (double)(WMUtil.RANDOM.nextFloat() * WMUtil.RANDOM.nextFloat() + 0.3f));
            dy *= d7;
            dz *= d7;
            if (!level.isClientSide()) continue;
            level.addParticle((ParticleOptions)ParticleTypes.POOF, (px + center.x) / 2.0, (py + center.y) / 2.0, (pz + center.z) / 2.0, dx, dy, dz);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, px, py, pz, dx, dy, dz);
        }
    }

    protected void calculateBlockExplosion() {
        int maxsize = 16;
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < maxsize; ++j) {
            for (int k = 0; k < maxsize; ++k) {
                for (int l = 0; l < maxsize; ++l) {
                    if (j != 0 && j != maxsize - 1 && k != 0 && k != maxsize - 1 && l != 0 && l != maxsize - 1) continue;
                    double rx = (float)j / 15.0f * 2.0f - 1.0f;
                    double ry = (float)k / 15.0f * 2.0f - 1.0f;
                    double rz = (float)l / 15.0f * 2.0f - 1.0f;
                    double rd = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    rx /= rd;
                    ry /= rd;
                    rz /= rd;
                    double dx = this.center.x;
                    double dy = this.center.y;
                    double dz = this.center.z;
                    float f = 0.3f;
                    for (float strength = this.explosionSize * (0.7f + WMUtil.RANDOM.nextFloat() * 0.6f); strength > 0.0f; strength -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.containing((double)dx, (double)dy, (double)dz);
                        BlockState iblockstate = this.serverLevel.getBlockState(blockpos);
                        if (!iblockstate.isAir()) {
                            strength -= (iblockstate.getBlock().getExplosionResistance() + 0.3f) * f;
                        }
                        if (strength > 0.0f) {
                            set.add(blockpos);
                        }
                        dx += rx * 0.3;
                        dy += ry * 0.3;
                        dz += rz * 0.3;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        this.blocksCalculated = true;
    }
}

