/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.AdvancedExplosion;
import ckathode.weaponmod.network.MsgExplosion;
import ckathode.weaponmod.network.WMMessagePipeline;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class PhysHelper {
    private static Vec3 kbMotion = Vec3.ZERO;
    private static int knockBackModifier = 0;

    public static AdvancedExplosion createStandardExplosion(ServerLevel world, Entity entity, Vec3 center, float size, boolean flame, Explosion.BlockInteraction mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, center, size, flame, mode);
        explosion.doEntityExplosion();
        explosion.doBlockExplosion();
        explosion.doParticleExplosion(true, true);
        PhysHelper.sendExplosion((Level)world, explosion, true, true);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(ServerLevel world, Entity entity, Vec3 center, float size, boolean destroyBlocks, boolean spawnSmallParticles, boolean spawnBigParticles, boolean flame, Explosion.BlockInteraction mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, center, size, flame, mode);
        explosion.doEntityExplosion();
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        if (flame) {
            explosion.doFlaming();
        }
        explosion.doParticleExplosion(spawnSmallParticles, spawnBigParticles);
        PhysHelper.sendExplosion((Level)world, explosion, spawnSmallParticles, spawnBigParticles);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(ServerLevel world, Entity entity, DamageSource damagesource, Vec3 center, float size, boolean destroyBlocks, boolean spawnSmallParticles, boolean spawnBigParticles, boolean flame, Explosion.BlockInteraction mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, center, size, flame, mode);
        explosion.doEntityExplosion(damagesource);
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        if (flame) {
            explosion.doFlaming();
        }
        explosion.doParticleExplosion(spawnSmallParticles, spawnBigParticles);
        PhysHelper.sendExplosion((Level)world, explosion, spawnSmallParticles, spawnBigParticles);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(ServerLevel world, Entity entity, Vec3 center, float size, boolean destroyBlocks, boolean spawnParticles, boolean flame, Explosion.BlockInteraction mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, center, size, flame, mode);
        explosion.doEntityExplosion();
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        if (flame) {
            explosion.doFlaming();
        }
        explosion.doParticleExplosion(spawnParticles, spawnParticles);
        PhysHelper.sendExplosion((Level)world, explosion, spawnParticles, spawnParticles);
        return explosion;
    }

    public static void sendExplosion(Level world, AdvancedExplosion explosion, boolean smallparts, boolean bigparts) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (!world.isClientSide()) {
                MsgExplosion msg = new MsgExplosion(explosion, smallparts, bigparts);
                WMMessagePipeline.sendToAround(msg, serverLevel, explosion.center.x, explosion.center.y, explosion.center.z, 64.0, (ResourceKey<Level>)world.dimension());
            }
        }
    }

    public static void knockBack(LivingEntity entityliving, LivingEntity attacker, float knockback) {
        entityliving.setDeltaMovement(kbMotion);
        double dx = attacker.getX() - entityliving.getX();
        double dz = attacker.getZ() - entityliving.getZ();
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        double f = Math.sqrt(dx * dx + dz * dz);
        Vec3 motion = entityliving.getDeltaMovement().add(new Vec3(-dx / f * (double)knockback, (double)knockback, -dz / f * (double)knockback));
        if (motion.y > 0.4) {
            motion = new Vec3(motion.x, 0.4, motion.z);
        }
        entityliving.setDeltaMovement(motion);
        if (knockBackModifier > 0) {
            dx = -Math.sin(Math.toRadians(attacker.getYRot())) * (double)knockBackModifier * 0.5;
            dz = Math.cos(Math.toRadians(attacker.getYRot())) * (double)knockBackModifier * 0.5;
            entityliving.push(dx, 0.1, dz);
        }
        if (entityliving instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityliving;
            serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)entityliving));
        }
        knockBackModifier = 0;
        kbMotion = Vec3.ZERO;
    }

    public static void prepareKnockbackOnEntity(LivingEntity attacker, LivingEntity entity) {
        Holder knockBack = attacker.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.KNOCKBACK).orElse(null);
        int n = knockBackModifier = knockBack == null ? 0 : EnchantmentHelper.getEnchantmentLevel((Holder)knockBack, (LivingEntity)attacker);
        if (attacker.isSprinting()) {
            ++knockBackModifier;
        }
        kbMotion = entity.getDeltaMovement();
    }
}

