/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="weaponmod")
public class WeaponModConfig
implements ConfigData {
    @ConfigEntry.Category(value="settings")
    @Comment(value="Whether the cannon should do block damage.")
    public volatile boolean cannonDoesBlockDamage = true;
    @ConfigEntry.Category(value="settings")
    @Comment(value="Whether dynamite should do block damage.")
    public volatile boolean dynamiteDoesBlockDamage = true;
    @ConfigEntry.Category(value="settings")
    @Comment(value="Whether the mortar should do block damage.")
    public volatile boolean mortarDoesBlockDamage = true;
    @ConfigEntry.Category(value="settings")
    @Comment(value="Whether the knife can be thrown.")
    public volatile boolean canThrowKnife = true;
    @ConfigEntry.Category(value="settings")
    @Comment(value="Whether the spear can be thrown.")
    public volatile boolean canThrowSpear = true;
    @ConfigEntry.Category(value="settings")
    @Comment(value="Change this to 'false' to allow only the thrower/shooter of the projectile to pick the item up. If set to 'true' everyone can pick the item up.")
    public volatile boolean allCanPickup = true;
    @ConfigEntry.Category(value="settings")
    @Comment(value="Show reload progress in hotbar.")
    public volatile boolean guiOverlayReloaded = true;
    @ConfigEntry.Category(value="settings")
    @Comment(value="Item model for entity (knife, spear, etc).")
    public volatile boolean itemModelForEntity = true;
    @ConfigEntry.Category(value="settings")
    @Comment(value="Changes the cannon to the legacy model from older versions of BWM!")
    public volatile boolean legacyCannonModel = false;
    @ConfigEntry.Category(value="enable")
    @StringBooleanMap
    @Comment(value="Enable/disable recipes for the different weapons.")
    private volatile Map<String, Boolean> enableSettings = new HashMap<String, Boolean>();
    @ConfigEntry.Category(value="reloadTimes")
    @StringIntMap
    @Comment(value="Change the reload times of the different weapons.")
    private volatile Map<String, Integer> reloadTimeSettings = new HashMap<String, Integer>();

    private WeaponModConfig() {
        this.addEnableSetting("spear");
        this.addEnableSetting("halberd");
        this.addEnableSetting("battleaxe");
        this.addEnableSetting("knife");
        this.addEnableSetting("warhammer");
        this.addEnableSetting("flail");
        this.addEnableSetting("katana");
        this.addEnableSetting("boomerang");
        this.addEnableSetting("firerod");
        this.addEnableSetting("javelin");
        this.addEnableSetting("crossbow");
        this.addEnableSetting("blowgun");
        this.addEnableSetting("musket");
        this.addEnableSetting("blunderbuss");
        this.addEnableSetting("flintlock");
        this.addEnableSetting("dynamite");
        this.addEnableSetting("cannon");
        this.addEnableSetting("dummy");
        this.addEnableSetting("mortar");
        this.addReloadTimeSetting("musket", 30);
        this.addReloadTimeSetting("crossbow", 15);
        this.addReloadTimeSetting("blowgun", 10);
        this.addReloadTimeSetting("blunderbuss", 20);
        this.addReloadTimeSetting("flintlock", 15);
        this.addReloadTimeSetting("mortar", 50);
    }

    private void addEnableSetting(String weapon) {
        this.enableSettings.put(weapon, true);
    }

    public boolean isEnabled(String weapon) {
        Boolean enabled = this.enableSettings.get(weapon);
        return enabled == null || enabled != false;
    }

    private void addReloadTimeSetting(String weapon, int defaultTime) {
        this.reloadTimeSettings.put(weapon, defaultTime);
    }

    public int getReloadTime(String weapon) {
        Integer time = this.reloadTimeSettings.get(weapon);
        return time == null ? 0 : time;
    }

    public static WeaponModConfig get() {
        return (WeaponModConfig)AutoConfig.getConfigHolder(WeaponModConfig.class).getConfig();
    }

    public static void init() {
        AutoConfig.register(WeaponModConfig.class, JanksonConfigSerializer::new);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface StringIntMap {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface StringBooleanMap {
    }
}

