/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity;

import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.item.IItemWeapon;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityDummy
extends Entity {
    public static final String ID = "dummy";
    public static final EntityType<EntityDummy> TYPE = WMRegistries.createEntityType("dummy", EntityDimensions.fixed((float)0.5f, (float)1.9f).withEyeHeight(0.0f), 4, 20, EntityDummy::new);
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.defineId(EntityDummy.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> ROCK_DIRECTION = SynchedEntityData.defineId(EntityDummy.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> CURRENT_DAMAGE = SynchedEntityData.defineId(EntityDummy.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int durability;

    public EntityDummy(EntityType<EntityDummy> entityType, Level world) {
        super(entityType, world);
        this.blocksBuilding = true;
        this.setXRot(-20.0f);
        this.setRot(this.getYRot(), this.getXRot());
        this.durability = 50;
    }

    public EntityDummy(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.setPos(d, d1, d2);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = d;
        this.yo = d1;
        this.zo = d2;
    }

    @NotNull
    public EntityType<?> getType() {
        return TYPE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TIME_SINCE_HIT, (Object)0);
        builder.define(ROCK_DIRECTION, (Object)1);
        builder.define(CURRENT_DAMAGE, (Object)0);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_DUMMY.get());
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damage) {
        if (!this.isAlive() || damage <= 0.0f) {
            return false;
        }
        this.setRockDirection(-this.getRockDirection());
        this.setTimeSinceHit(10);
        int i = this.getCurrentDamage();
        if ((i += (int)(damage * 5.0f)) > 50) {
            i = 50;
        }
        this.setCurrentDamage(i);
        this.markHurt();
        Entity entity = damageSource.getEntity();
        if (entity == null) {
            this.durability -= (int)damage;
        } else if (damageSource.is(WMDamageSources.WEAPON)) {
            if (entity.getDeltaMovement().length() > 0.5) {
                entity.setDeltaMovement(entity.getDeltaMovement().scale((double)0.1f));
                this.playRandomHitSound();
            } else {
                entity.setDeltaMovement((double)(this.random.nextFloat() - 0.5f), (double)(this.random.nextFloat() - 0.5f), (double)(this.random.nextFloat() - 0.5f));
            }
        } else {
            this.playRandomHitSound();
        }
        if (this.durability <= 0 && serverLevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.dropAsItem((Level)serverLevel, true, true);
        }
        this.markHurt();
        return false;
    }

    public void playRandomHitSound() {
        int i = this.random.nextInt(2);
        if (i == 0) {
            this.playSound(SoundEvents.WOOL_STEP, 0.7f, 1.0f / (this.random.nextFloat() * 0.2f + 0.4f));
        } else {
            this.playSound(SoundEvents.WOOD_STEP, 0.7f, 1.0f / (this.random.nextFloat() * 0.2f + 0.2f));
        }
    }

    public void animateHurt(float yaw) {
        this.setRockDirection(-this.getRockDirection());
        this.setTimeSinceHit(10);
        this.setCurrentDamage(this.getCurrentDamage() + 10);
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public void tick() {
        super.tick();
        int i = this.getTimeSinceHit();
        if (i > 0) {
            this.setTimeSinceHit(i - 1);
        }
        if ((i = this.getCurrentDamage()) > 0) {
            this.setCurrentDamage(i - this.random.nextInt(2));
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.onGround()) {
            this.setDeltaMovement(Vec3.ZERO);
        } else {
            Vec3 motion = this.getDeltaMovement();
            double motionX = motion.x * 0.99;
            double motionZ = motion.z * 0.99;
            double motionY = motion.y - 0.05;
            this.fallDistance += (double)((float)(-motionY));
            this.setDeltaMovement(motionX, motionY, motionZ);
        }
        this.setRot(this.getYRot(), this.getXRot());
        this.move(MoverType.SELF, new Vec3(0.0, this.getDeltaMovement().y, 0.0));
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.2, 0.0, 0.2), EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.hasPassenger((Entity)this)) continue;
                this.push(entity);
            }
        }
    }

    public boolean causeFallDamage(double fallDistance, float multiplier, DamageSource source) {
        super.causeFallDamage(fallDistance, multiplier, source);
        if (!this.onGround()) {
            return false;
        }
        int i = Mth.floor((double)fallDistance);
        WMUtil.hurt(this, this.damageSources().fall(), i);
        return false;
    }

    public void dropAsItem(Level level, boolean destroyed, boolean noCreative) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (destroyed) {
                for (int i = 0; i < this.random.nextInt(8); ++i) {
                    this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)Items.LEATHER), 1.0f);
                }
            } else if (noCreative) {
                this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)WMRegistries.ITEM_DUMMY.get()), 1.0f);
            }
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    @NotNull
    public InteractionResult interact(Player entityplayer, @NotNull InteractionHand hand) {
        ItemStack itemstack = entityplayer.getInventory().getSelectedItem();
        if (!itemstack.isEmpty() && (itemstack.getItem() instanceof IItemWeapon || itemstack.is(ItemTags.SWORDS) || itemstack.getItem() instanceof BowItem || itemstack.getItem() instanceof ShieldItem)) {
            return InteractionResult.FAIL;
        }
        if (entityplayer.isCreative()) {
            this.dropAsItem(this.level(), false, false);
            return InteractionResult.SUCCESS;
        }
        this.dropAsItem(this.level(), false, true);
        return InteractionResult.SUCCESS;
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.setPos(this.getX(), this.getY(), this.getZ());
        this.setRot(this.getYRot(), this.getXRot());
    }

    public void setTimeSinceHit(int i) {
        this.entityData.set(TIME_SINCE_HIT, (Object)i);
    }

    public void setRockDirection(int i) {
        this.entityData.set(ROCK_DIRECTION, (Object)((byte)i));
    }

    public void setCurrentDamage(int i) {
        this.entityData.set(CURRENT_DAMAGE, (Object)i);
    }

    public int getTimeSinceHit() {
        return (Integer)this.entityData.get(TIME_SINCE_HIT);
    }

    public int getRockDirection() {
        return ((Byte)this.entityData.get(ROCK_DIRECTION)).byteValue();
    }

    public int getCurrentDamage() {
        return (Integer)this.entityData.get(CURRENT_DAMAGE);
    }
}

