/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.IItemWeapon;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityBoomerang
extends EntityMaterialProjectile<EntityBoomerang> {
    public static final String ID = "boomerang";
    public static final EntityType<EntityBoomerang> TYPE = WMRegistries.createEntityType("boomerang", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityBoomerang::new);
    private static final EntityDataAccessor<Float> BOOMERANG = SynchedEntityData.defineId(EntityBoomerang.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final double RETURN_STRENGTH = 0.05;
    public static final float MIN_FLOAT_STRENGTH = 0.4f;
    private float soundTimer;
    public float floatStrength;

    public EntityBoomerang(EntityType<EntityBoomerang> entityType, Level world) {
        super(entityType, world);
    }

    public EntityBoomerang(Level world, double x, double y, double z, @Nullable ItemStack firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPos(x, y, z);
    }

    public EntityBoomerang(Level world, LivingEntity shooter, ItemStack itemstack) {
        this(world, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ(), itemstack);
        this.setOwner((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
        this.soundTimer = 0.0f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
        this.floatStrength = Math.min(1.5f, f3);
        this.entityData.set(BOOMERANG, (Object)Float.valueOf(this.floatStrength));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOOMERANG, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void tick() {
        Entity shooter;
        super.tick();
        this.floatStrength = ((Float)this.entityData.get(BOOMERANG)).floatValue();
        if (this.inGround) {
            return;
        }
        this.floatStrength *= 0.994f;
        if (this.floatStrength < 0.4f) {
            if (this.isCritArrow()) {
                this.setCritArrow(false);
            }
            this.floatStrength = 0.0f;
        }
        float limitedStrength = Math.min(1.0f, this.floatStrength);
        if (!this.beenInGround) {
            this.setYRot(this.getYRot() + 20.0f * this.floatStrength);
        }
        if (!this.beenInGround && (shooter = this.getOwner()) != null && this.floatStrength > 0.0f) {
            Vec3 d = this.position().subtract(shooter.position()).subtract(0.0, (double)shooter.getEyeHeight(), 0.0).normalize();
            this.setDeltaMovement(this.getDeltaMovement().subtract(d.scale(0.05)));
            this.soundTimer += limitedStrength;
            if (this.soundTimer > 3.0f) {
                this.playSound(SoundEvents.ARROW_SHOOT, 0.6f, 1.0f / (this.random.nextFloat() * 0.2f + 2.2f - limitedStrength));
                this.soundTimer %= 3.0f;
            }
        }
        this.entityData.set(BOOMERANG, (Object)Float.valueOf(this.floatStrength));
    }

    @Override
    @NotNull
    public DamageSource getDamageSource() {
        return this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        Item item;
        Entity shooter;
        if (this.level().isClientSide() || this.floatStrength < 0.4f) {
            return;
        }
        Entity entity = result.getEntity();
        if (entity == (shooter = this.getOwner())) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack item2 = this.getPickupItem();
                if (item2.isEmpty()) {
                    return;
                }
                if (player.isCreative() || player.getInventory().add(item2)) {
                    this.playSound(SoundEvents.ITEM_PICKUP, 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.onItemPickup(player);
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
            return;
        }
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem.isEmpty() || !((item = thrownItem.getItem()) instanceof IItemWeapon)) {
            return;
        }
        IItemWeapon iiw = (IItemWeapon)item;
        float damage = iiw.getMeleeComponent().getEntityDamage() + 2.0f + this.extraDamage;
        damage = this.applyEnchantmentBonus(entity, damage);
        if (this.isCritArrow()) {
            damage += 2.0f;
        }
        if (WMUtil.hurtOrSimulate(entity, this.getDamageSource(), damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            if (thrownItem.getDamageValue() + 1 >= thrownItem.getMaxDamage()) {
                thrownItem.shrink(1);
                this.remove(Entity.RemovalReason.DISCARDED);
            } else {
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerPlayer player;
                    ServerLevel serverLevel = (ServerLevel)level;
                    thrownItem.hurtAndBreak(1, serverLevel, shooter instanceof ServerPlayer ? (player = (ServerPlayer)shooter) : null, i -> {});
                }
                this.lerpMotion(Vec3.ZERO);
            }
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void onHitBlock(BlockHitResult result) {
        BlockPos blockpos = result.getBlockPos();
        this.xTile = blockpos.getX();
        this.yTile = blockpos.getY();
        this.zTile = blockpos.getZ();
        this.inBlockState = this.level().getBlockState(blockpos);
        Vec3 motion = result.getLocation().subtract(this.position());
        this.setDeltaMovement(motion);
        Vec3 newPos = this.position().subtract(motion.normalize().scale(0.05));
        this.setPos(newPos.x, newPos.y, newPos.z);
        this.setDeltaMovement((double)(-this.random.nextFloat() * 0.5f) * motion.x, this.random.nextFloat() * 0.1f, (double)(-this.random.nextFloat() * 0.5f) * motion.z);
        this.inGround = result.getDirection() == Direction.UP;
        this.setCritArrow(false);
        this.beenInGround = true;
        this.floatStrength = 0.0f;
        if (this.inBlockState != null) {
            WMUtil.entityInside(this.inBlockState, this.level(), blockpos, (Entity)this, InsideBlockEffectApplier.NOOP, true);
        }
    }

    @Override
    public void playHitSound() {
        this.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public boolean aimRotation() {
        return this.beenInGround || this.floatStrength < 0.4f;
    }

    @Override
    public int getMaxLifetime() {
        return this.pickupStatus == EntityProjectile.PickupStatus.ALLOWED || this.pickupStatus == EntityProjectile.PickupStatus.OWNER_ONLY ? 0 : 1200;
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public double getDefaultGravity() {
        return this.beenInGround || this.floatStrength < 0.4f ? (double)0.05f : 0.0;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public void playerTouch(@NotNull Player entityplayer) {
        if (!this.beenInGround && this.ticksInAir > 5 && !this.level().isClientSide() && this.floatStrength >= 0.4f && entityplayer.equals((Object)this.getOwner())) {
            ItemStack item = this.getPickupItem();
            if (item.isEmpty()) {
                return;
            }
            if (entityplayer.isCreative() || entityplayer.getInventory().add(item)) {
                this.playSound(SoundEvents.ITEM_PICKUP, 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
        super.playerTouch(entityplayer);
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_BOOMERANG_WOOD.get());
    }
}

