/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCrossbowBolt
extends EntityProjectile<EntityCrossbowBolt> {
    public static final String ID = "bolt";
    public static final EntityType<EntityCrossbowBolt> TYPE = WMRegistries.createEntityType("bolt", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityCrossbowBolt::new);

    public EntityCrossbowBolt(EntityType<EntityCrossbowBolt> entityType, Level world) {
        super(entityType, world);
    }

    public EntityCrossbowBolt(Level world, double d, double d1, double d2, @Nullable ItemStack firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        this.setPos(d, d1, d2);
    }

    public EntityCrossbowBolt(Level world, LivingEntity shooter, @Nullable ItemStack firedFromWeapon) {
        this(world, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ(), firedFromWeapon);
        this.setOwner((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
    }

    @Override
    @NotNull
    public DamageSource getDamageSource() {
        return this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        float vel = (float)this.getTotalVelocity();
        float damage = vel * 4.0f + this.extraDamage;
        if (WMUtil.hurtOrSimulate(entity, this.getDamageSource(), damage)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.level().isClientSide()) {
                    livingEntity.setArrowCount(livingEntity.getArrowCount() + 1);
                }
            }
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void playHitSound() {
        this.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.4f));
    }

    @Override
    public int getMaxArrowShake() {
        return 4;
    }

    @Override
    @NotNull
    protected ItemStack getPickupItem() {
        return this.getDefaultPickupItem();
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_CROSSBOW_BOLT.get());
    }
}

