/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.IItemWeapon;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityKnife
extends EntityMaterialProjectile<EntityKnife> {
    public static final String ID = "knife";
    public static final EntityType<EntityKnife> TYPE = WMRegistries.createEntityType("knife", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityKnife::new);
    private int soundTimer;

    public EntityKnife(EntityType<EntityKnife> entityType, Level world) {
        super(entityType, world);
    }

    public EntityKnife(Level world, double d, double d1, double d2, @Nullable ItemStack firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPos(d, d1, d2);
    }

    public EntityKnife(Level world, LivingEntity shooter, ItemStack itemstack) {
        this(world, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ(), itemstack);
        this.setOwner((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
        this.soundTimer = 0;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.inGround || this.beenInGround) {
            return;
        }
        this.xRot -= 70.0f;
        if (this.xRot <= -360.0f) {
            this.xRot += 360.0f;
        }
        if (this.soundTimer >= 3) {
            if (!this.isInWater()) {
                this.playSound(SoundEvents.ARROW_SHOOT, 0.6f, 1.0f / (this.random.nextFloat() * 0.2f + 0.6f + (float)this.ticksInAir / 15.0f));
            }
            this.soundTimer = 0;
        }
        ++this.soundTimer;
    }

    @Override
    @NotNull
    public DamageSource getDamageSource() {
        return this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        if (this.level().isClientSide()) {
            return;
        }
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem.isEmpty()) {
            return;
        }
        Item item = thrownItem.getItem();
        if (!(item instanceof IItemWeapon)) {
            this.bounceBack();
            return;
        }
        IItemWeapon iweapon = (IItemWeapon)item;
        Entity entity = result.getEntity();
        float damage = iweapon.getMeleeComponent().getEntityDamage();
        damage = this.applyEnchantmentBonus(entity, damage);
        if (WMUtil.hurtOrSimulate(entity, this.getDamageSource(), damage)) {
            this.applyEntityHitEffects(entity);
            if (thrownItem.getDamageValue() + 2 >= thrownItem.getMaxDamage()) {
                thrownItem.shrink(1);
                this.remove(Entity.RemovalReason.DISCARDED);
            } else {
                Entity shooter = this.getOwner();
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerPlayer player;
                    ServerLevel serverLevel = (ServerLevel)level;
                    thrownItem.hurtAndBreak(2, serverLevel, shooter instanceof ServerPlayer ? (player = (ServerPlayer)shooter) : null, i -> {});
                }
                this.lerpMotion(Vec3.ZERO);
            }
        }
    }

    @Override
    public boolean aimRotation() {
        return this.beenInGround;
    }

    @Override
    public int getMaxLifetime() {
        return this.pickupStatus == EntityProjectile.PickupStatus.ALLOWED || this.pickupStatus == EntityProjectile.PickupStatus.OWNER_ONLY ? 0 : 1200;
    }

    @Override
    public int getMaxArrowShake() {
        return 4;
    }

    @Override
    public double getDefaultGravity() {
        return 0.03f;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_KNIFE_WOOD.get());
    }
}

