/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMusketBullet
extends EntityProjectile<EntityMusketBullet> {
    public static final String ID = "bullet";
    public static final EntityType<EntityMusketBullet> TYPE = WMRegistries.createEntityType("bullet", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityMusketBullet::new);

    public EntityMusketBullet(EntityType<EntityMusketBullet> entityType, Level world) {
        super(entityType, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
    }

    public EntityMusketBullet(Level world, double d, double d1, double d2, @Nullable ItemStack firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        this.setPos(d, d1, d2);
    }

    public EntityMusketBullet(Level world, LivingEntity shooter, @Nullable ItemStack firedFromWeapon) {
        this(world, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ(), firedFromWeapon);
        this.setOwner((Entity)shooter);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.inGround) {
            if (this.random.nextInt(4) == 0 && this.level().isClientSide()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
            return;
        }
        double speed = this.getTotalVelocity();
        double amount = 16.0;
        if (speed > 2.0) {
            int i1 = 1;
            while ((double)i1 < amount) {
                Vec3 pos = this.position().add(this.getDeltaMovement().scale((double)i1 / amount));
                if (this.level().isClientSide()) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.POOF, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                }
                ++i1;
            }
        }
    }

    @Override
    @NotNull
    public DamageSource getDamageSource() {
        return this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        float damage = 20.0f + this.extraDamage;
        if (WMUtil.hurtOrSimulate(entity, this.getDamageSource(), damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxLifetime() {
        return 200;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public double getDefaultGravity() {
        return this.getTotalVelocity() < 3.0 ? (double)0.07f : 0.0;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_MUSKET_BULLET.get());
    }
}

