/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile.dispense;

import ckathode.weaponmod.entity.projectile.EntityBlunderShot;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DispenseBlunderShot
extends DefaultDispenseItemBehavior {
    private final Random rand = new Random();

    @NotNull
    public ItemStack execute(BlockSource blocksource, ItemStack itemstack) {
        Direction face = (Direction)blocksource.state().getValue((Property)DispenserBlock.FACING);
        Position pos = DispenserBlock.getDispensePosition((BlockSource)blocksource);
        EntityBlunderShot.fireFromDispenser((Level)blocksource.level(), pos.x() + (double)face.getStepX(), pos.y() + (double)face.getStepY(), pos.z() + (double)face.getStepZ(), face.getStepX(), face.getStepY(), face.getStepZ());
        itemstack.shrink(1);
        return itemstack;
    }

    protected void playSound(BlockSource blocksource) {
        blocksource.level().playSound(null, blocksource.pos(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.NEUTRAL, 3.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.6f));
    }

    protected void playAnimation(@NotNull BlockSource blocksource, @NotNull Direction face) {
        super.playAnimation(blocksource, face);
        Position pos = DispenserBlock.getDispensePosition((BlockSource)blocksource);
        if (blocksource.level().isClientSide()) {
            blocksource.level().addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x() + (double)face.getStepX(), pos.y() + (double)face.getStepY(), pos.z() + (double)face.getStepZ(), 0.0, 0.0, 0.0);
        }
    }
}

