/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.entity.projectile.EntityBlowgunDart;
import ckathode.weaponmod.entity.projectile.dispense.WMDispenserExtension;
import ckathode.weaponmod.item.DartType;
import ckathode.weaponmod.item.WMItem;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemBlowgunDart
extends WMItem
implements WMDispenserExtension {
    public static final String ID_PREFIX = "dart";
    public static final Map<DartType, ItemBlowgunDart> ITEMS = DartType.DART_TYPES.stream().map(t -> new Pair(t, (Object)WMItemBuilder.createStandardBlowgunDart(t, BalkonsWeaponMod.id(t.typeName())))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    @NotNull
    private final DartType dartType;

    public ItemBlowgunDart(@NotNull DartType dartType, @NotNull ResourceLocation id) {
        super(ItemBlowgunDart.getBaseProperties(id).component(DataComponents.POTION_CONTENTS, (Object)dartType.potionContents()));
        this.dartType = dartType;
    }

    @NotNull
    public DartType getDartType() {
        return this.dartType;
    }

    @NotNull
    private static DartType getDartType(@NotNull ItemStack stack) {
        DartType dartType;
        Item item = stack.getItem();
        if (item instanceof ItemBlowgunDart) {
            ItemBlowgunDart dart = (ItemBlowgunDart)item;
            dartType = dart.getDartType();
        } else {
            dartType = DartType.DAMAGE;
        }
        return dartType;
    }

    public static Iterable<MobEffectInstance> getEffects(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return Collections.emptyList();
        }
        PotionContents effects = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return effects.getAllEffects();
    }

    public static float[] getColor(ItemStack stack) {
        if (stack.isEmpty()) {
            return DartType.DAMAGE.color();
        }
        return ItemBlowgunDart.getDartType(stack).color();
    }

    @NotNull
    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        EntityBlowgunDart dart = new EntityBlowgunDart(level, pos.x(), pos.y(), pos.z(), null);
        dart.setThrownItemStack(stack);
        return dart;
    }

    @NotNull
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().power(3.0f).uncertainty(2.0f).build();
    }

    @Override
    public void playSound(@NotNull Consumer<BlockSource> origFn, @NotNull BlockSource blockSource) {
        blockSource.level().playSound(null, blockSource.pos(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 1.0f, 1.2f);
    }
}

