/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.entity.projectile.EntityMusketBullet;
import ckathode.weaponmod.item.ItemMusket;
import ckathode.weaponmod.item.RangedComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RangedCompMusket
extends RangedComponent {
    protected ItemMusket musket;

    public RangedCompMusket() {
        super(RangedComponent.RangedSpecs.MUSKET);
    }

    @Override
    protected void onSetItem() {
        super.onSetItem();
        Item item = this.item;
        if (item instanceof ItemMusket) {
            ItemMusket m;
            this.musket = m = (ItemMusket)item;
        }
    }

    @Override
    public void effectReloadDone(ItemStack itemstack, Level world, LivingEntity entityliving) {
        entityliving.swing(InteractionHand.MAIN_HAND);
        world.playSound(null, entityliving.getX(), entityliving.getY(), entityliving.getZ(), SoundEvents.COMPARATOR_CLICK, SoundSource.PLAYERS, 1.0f, 1.0f / (entityliving.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public void fire(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        boolean flag;
        int j = this.getUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        f += 0.02f;
        if (!world.isClientSide()) {
            EntityMusketBullet entitymusketbullet = new EntityMusketBullet(world, entityliving, itemstack);
            entitymusketbullet.shootFromRotation((Entity)entityliving, entityliving.getXRot(), entityliving.getYRot(), 0.0f, 5.0f, 1.0f / f);
            RangedCompMusket.applyProjectileEnchantments(entitymusketbullet, itemstack);
            world.addFreshEntity((Entity)entitymusketbullet);
        }
        int deltaDamage = 1;
        boolean bl = flag = itemstack.getDamageValue() + deltaDamage >= itemstack.getMaxDamage();
        if (flag && this.musket != null && this.musket.hasBayonet()) {
            short bayonetDamage = itemstack.has(ItemMusket.BAYONET_DAMAGE_TYPE) ? (Short)itemstack.get(ItemMusket.BAYONET_DAMAGE_TYPE) : (short)0;
            ItemStack newStack = new ItemStack((ItemLike)this.musket.bayonetItem, 1);
            newStack.setDamageValue((int)bayonetDamage);
            itemstack.hurtAndBreak(deltaDamage, entityliving, entityliving.getUsedItemHand().asEquipmentSlot());
            if (entityliving instanceof Player) {
                Player entityplayer = (Player)entityliving;
                entityplayer.getInventory().add(newStack);
            }
        } else {
            itemstack.hurtAndBreak(deltaDamage, entityliving, entityliving.getUsedItemHand().asEquipmentSlot());
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
        }
        this.postShootingEffects(itemstack, entityliving, world);
    }

    @Override
    public void effectPlayer(ItemStack itemstack, Player entityplayer, Level world) {
        float f = entityplayer.isShiftKeyDown() ? -0.05f : -0.1f;
        double d = -Mth.sin((float)(entityplayer.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)0.0f) * f;
        double d2 = Mth.cos((float)(entityplayer.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)0.0f) * f;
        entityplayer.setXRot(entityplayer.getXRot() - (entityplayer.isShiftKeyDown() ? 7.5f : 15.0f));
        entityplayer.push(d, 0.0, d2);
    }

    @Override
    public void effectShoot(Level world, double x, double y, double z, float yaw, float pitch) {
        world.playSound(null, x, y, z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.PLAYERS, 3.0f, 1.0f / (WMUtil.RANDOM.nextFloat() * 0.4f + 0.7f));
        world.playSound(null, x, y, z, SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.PLAYERS, 3.0f, 1.0f / (WMUtil.RANDOM.nextFloat() * 0.4f + 0.4f));
        float particleX = -Mth.sin((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        float particleY = -Mth.sin((float)(pitch * ((float)Math.PI / 180))) + 1.6f;
        float particleZ = Mth.cos((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        if (world.isClientSide()) {
            for (int i = 0; i < 3; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + (double)particleX, y + (double)particleY, z + (double)particleZ, 0.0, 0.0, 0.0);
            }
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, x + (double)particleX, y + (double)particleY, z + (double)particleZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public float getMaxZoom() {
        return 0.15f;
    }
}

