/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.network;

import ckathode.weaponmod.AdvancedExplosion;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public record MsgExplosion(Vec3 center, float size, List<BlockPos> blocks, boolean smallParticles, boolean bigParticles) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MsgExplosion> EXPLOSION_PACKET_TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"weaponmod", (String)"explosion"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MsgExplosion> STREAM_CODEC = StreamCodec.composite((StreamCodec)Vec3.STREAM_CODEC, MsgExplosion::center, (StreamCodec)ByteBufCodecs.FLOAT, MsgExplosion::size, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), MsgExplosion::blocks, (StreamCodec)ByteBufCodecs.BOOL, MsgExplosion::smallParticles, (StreamCodec)ByteBufCodecs.BOOL, MsgExplosion::bigParticles, MsgExplosion::new);

    public MsgExplosion(AdvancedExplosion explosion, boolean smallparts, boolean bigparts) {
        this(explosion.center, explosion.explosionSize, (List<BlockPos>)explosion.toBlow, smallparts, bigparts);
    }

    public MsgExplosion(double x, double y, double z, float size, List<BlockPos> blocks, boolean smallparts, boolean bigparts) {
        this(new Vec3(x, y, z), size, blocks, smallparts, bigparts);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return EXPLOSION_PACKET_TYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(MsgExplosion msg, NetworkManager.PacketContext ctx) {
        Level level = ctx.getPlayer().level();
        AdvancedExplosion.doParticleExplosion(level, msg.center, msg.blocks, msg.size, msg.smallParticles, msg.bigParticles);
    }
}

