/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.render.WMRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class WMItemEntityRenderer<T extends Entity, S extends WMItemEntityRendererState>
extends WMRenderer<T, S> {
    protected final ItemModelResolver itemModelResolver;

    protected WMItemEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void submit(S entityRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!WeaponModConfig.get().itemModelForEntity) {
            this.submitNormalRender(entityRenderState, poseStack, submitNodeCollector, cameraRenderState);
        } else {
            this.submitItemRender(entityRenderState, poseStack, submitNodeCollector, cameraRenderState);
        }
        super.submit(entityRenderState, poseStack, submitNodeCollector, cameraRenderState);
    }

    public abstract void submitNormalRender(S var1, PoseStack var2, SubmitNodeCollector var3, CameraRenderState var4);

    public abstract void submitItemRender(S var1, PoseStack var2, SubmitNodeCollector var3, CameraRenderState var4);

    public abstract ItemStack getRenderStack(T var1, S var2, float var3);

    @Override
    public void extractRenderState(T entity, S entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        ItemStack weapon = this.getRenderStack(entity, entityRenderState, f);
        this.itemModelResolver.updateForTopItem(((WMItemEntityRendererState)((Object)entityRenderState)).itemRender, weapon, ItemDisplayContext.FIXED, entity.level(), null, 0);
    }

    public static class WMItemEntityRendererState
    extends WMRenderer.WMRendererState {
        public final ItemStackRenderState itemRender = new ItemStackRenderState();
    }
}

