/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AdvancedExplosion
extends Explosion {
    protected static final Random rand = new Random();
    public final Level worldObj;
    public final double explosionX;
    public final double explosionY;
    public final double explosionZ;
    public final Entity exploder;
    public final float explosionSize;
    protected boolean blocksCalculated;

    public AdvancedExplosion(Level world, Entity entity, double x, double y, double z, float size, boolean flame, Explosion.BlockInteraction mode) {
        super(world, entity, null, null, x, y, z, size, flame, mode);
        this.worldObj = world;
        this.exploder = entity;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.explosionSize = size;
    }

    public void setAffectedBlockPositions(List<BlockPos> list) {
        this.m_46081_().addAll(list);
        this.blocksCalculated = true;
    }

    public void doEntityExplosion() {
        this.doEntityExplosion(DamageSource.m_19358_((Explosion)this));
    }

    public void doEntityExplosion(DamageSource damagesource) {
        float size = this.explosionSize * 2.0f;
        int k1 = Mth.m_14107_((double)(this.explosionX - (double)size - 1.0));
        int l1 = Mth.m_14107_((double)(this.explosionX + (double)size + 1.0));
        int i2 = Mth.m_14107_((double)(this.explosionY - (double)size - 1.0));
        int i3 = Mth.m_14107_((double)(this.explosionY + (double)size + 1.0));
        int j2 = Mth.m_14107_((double)(this.explosionZ - (double)size - 1.0));
        int j3 = Mth.m_14107_((double)(this.explosionZ + (double)size + 1.0));
        List list = this.worldObj.m_45933_(this.exploder, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i3, (double)j3));
        Vec3 vec31 = new Vec3(this.explosionX, this.explosionY, this.explosionZ);
        for (Entity entity : list) {
            double dz;
            double dy;
            double dx;
            double d;
            double dr;
            if (entity.m_6128_() || !((dr = Math.sqrt(entity.m_20275_(this.explosionX, this.explosionY, this.explosionZ)) / (double)size) <= 1.0) || (d = Math.sqrt((dx = entity.m_20185_() - this.explosionX) * dx + (dy = entity.m_20186_() - this.explosionY) * dy + (dz = entity.m_20189_() - this.explosionZ) * dz)) == 0.0) continue;
            dx /= d;
            dy /= d;
            dz /= d;
            double dens = AdvancedExplosion.m_46064_((Vec3)vec31, (Entity)entity);
            double var36 = (1.0 - dr) * dens;
            int damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)size + 1.0);
            entity.m_6469_(damagesource, (float)damage);
            entity.m_20256_(entity.m_20184_().m_82520_(dx * var36, dy * var36, dz * var36));
        }
    }

    public void doBlockExplosion() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        ObjectArrayList objectarraylist = new ObjectArrayList();
        List positions = this.m_46081_();
        Collections.shuffle(positions, this.worldObj.f_46441_);
        for (BlockPos blockpos : positions) {
            Level level;
            BlockState blockstate = this.worldObj.m_8055_(blockpos);
            Block block = blockstate.m_60734_();
            if (blockstate.m_60795_()) continue;
            BlockPos blockpos1 = blockpos.m_7949_();
            this.worldObj.m_46473_().m_6180_("explosion_blocks");
            if (block.m_6903_((Explosion)this) && (level = this.worldObj) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockEntity tileentity = blockstate.m_155947_() ? this.worldObj.m_7702_(blockpos) : null;
                LootContext.Builder lcBuilder = new LootContext.Builder(serverLevel).m_78977_(this.worldObj.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)tileentity).m_78984_(LootContextParams.f_81455_, (Object)this.exploder).m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.explosionSize));
                blockstate.m_60724_(lcBuilder).forEach(s -> AdvancedExplosion.m_46067_((ObjectArrayList)objectarraylist, (ItemStack)s, (BlockPos)blockpos1));
            }
            this.worldObj.m_46597_(blockpos, Blocks.f_50016_.m_49966_());
            block.m_7592_(this.worldObj, blockpos, (Explosion)this);
            this.worldObj.m_46473_().m_7238_();
        }
        for (Pair pair : objectarraylist) {
            Block.m_49840_((Level)this.worldObj, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    public void doFlaming() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (BlockPos blockpos : this.m_46081_()) {
            if (!this.worldObj.m_8055_(blockpos).m_60795_() || !this.worldObj.m_8055_(blockpos.m_7495_()).m_60804_((BlockGetter)this.worldObj, blockpos.m_7495_()) || rand.nextInt(3) != 0) continue;
            this.worldObj.m_46597_(blockpos, Blocks.f_50083_.m_49966_());
        }
    }

    public void doParticleExplosion(boolean smallparticles, boolean bigparticles) {
        this.worldObj.m_6263_(null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.worldObj.f_46441_.nextFloat() - this.worldObj.f_46441_.nextFloat()) * 0.2f) * 0.7f);
        if (bigparticles) {
            this.worldObj.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0, 0.0);
        }
        if (!smallparticles) {
            return;
        }
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (BlockPos blockpos : this.m_46081_()) {
            double px = (float)blockpos.m_123341_() + this.worldObj.f_46441_.nextFloat();
            double py = (float)blockpos.m_123342_() + this.worldObj.f_46441_.nextFloat();
            double pz = (float)blockpos.m_123343_() + this.worldObj.f_46441_.nextFloat();
            double dx = px - this.explosionX;
            double dy = py - this.explosionY;
            double dz = pz - this.explosionZ;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            dx /= distance;
            dy /= distance;
            dz /= distance;
            double d7 = 0.5 / (distance / (double)this.explosionSize + 0.1);
            this.worldObj.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (px + this.explosionX) / 2.0, (py + this.explosionY) / 2.0, (pz + this.explosionZ) / 2.0, dx *= (d7 *= (double)(this.worldObj.f_46441_.nextFloat() * this.worldObj.f_46441_.nextFloat() + 0.3f)), dy *= d7, dz *= d7);
            this.worldObj.m_7106_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, dx, dy, dz);
        }
    }

    protected void calculateBlockExplosion() {
        int maxsize = 16;
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < maxsize; ++j) {
            for (int k = 0; k < maxsize; ++k) {
                for (int l = 0; l < maxsize; ++l) {
                    if (j != 0 && j != maxsize - 1 && k != 0 && k != maxsize - 1 && l != 0 && l != maxsize - 1) continue;
                    double rx = (float)j / 15.0f * 2.0f - 1.0f;
                    double ry = (float)k / 15.0f * 2.0f - 1.0f;
                    double rz = (float)l / 15.0f * 2.0f - 1.0f;
                    double rd = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    rx /= rd;
                    ry /= rd;
                    rz /= rd;
                    double dx = this.explosionX;
                    double dy = this.explosionY;
                    double dz = this.explosionZ;
                    float f = 0.3f;
                    for (float strength = this.explosionSize * (0.7f + this.worldObj.f_46441_.nextFloat() * 0.6f); strength > 0.0f; strength -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(dx, dy, dz);
                        BlockState iblockstate = this.worldObj.m_8055_(blockpos);
                        if (!iblockstate.m_60795_()) {
                            strength -= (iblockstate.m_60734_().m_7325_() + 0.3f) * f;
                        }
                        if (strength > 0.0f) {
                            set.add(blockpos);
                        }
                        dx += rx * 0.3;
                        dy += ry * 0.3;
                        dz += rz * 0.3;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
        this.blocksCalculated = true;
    }
}

