/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.AdvancedExplosion;
import ckathode.weaponmod.network.MsgExplosion;
import ckathode.weaponmod.network.WMMessagePipeline;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class PhysHelper {
    private static Vec3 kbMotion = Vec3.f_82478_;
    private static int knockBackModifier = 0;

    public static AdvancedExplosion createStandardExplosion(Level world, Entity entity, double d, double d1, double d2, float size, boolean flame, Explosion.BlockInteraction mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size, flame, mode);
        explosion.doEntityExplosion();
        explosion.doBlockExplosion();
        explosion.doParticleExplosion(true, true);
        PhysHelper.sendExplosion(world, explosion, true, true);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(Level world, Entity entity, double d, double d1, double d2, float size, boolean destroyBlocks, boolean spawnSmallParticles, boolean spawnBigParticles, boolean flame, Explosion.BlockInteraction mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size, flame, mode);
        explosion.doEntityExplosion();
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        if (flame) {
            explosion.doFlaming();
        }
        explosion.doParticleExplosion(spawnSmallParticles, spawnBigParticles);
        PhysHelper.sendExplosion(world, explosion, spawnSmallParticles, spawnBigParticles);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(Level world, Entity entity, DamageSource damagesource, double d, double d1, double d2, float size, boolean destroyBlocks, boolean spawnSmallParticles, boolean spawnBigParticles, boolean flame, Explosion.BlockInteraction mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size, flame, mode);
        explosion.doEntityExplosion(damagesource);
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        if (flame) {
            explosion.doFlaming();
        }
        explosion.doParticleExplosion(spawnSmallParticles, spawnBigParticles);
        PhysHelper.sendExplosion(world, explosion, spawnSmallParticles, spawnBigParticles);
        return explosion;
    }

    public static AdvancedExplosion createAdvancedExplosion(Level world, Entity entity, double d, double d1, double d2, float size, boolean destroyBlocks, boolean spawnParticles, boolean flame, Explosion.BlockInteraction mode) {
        AdvancedExplosion explosion = new AdvancedExplosion(world, entity, d, d1, d2, size, flame, mode);
        explosion.doEntityExplosion();
        if (destroyBlocks) {
            explosion.doBlockExplosion();
        }
        if (flame) {
            explosion.doFlaming();
        }
        explosion.doParticleExplosion(spawnParticles, spawnParticles);
        PhysHelper.sendExplosion(world, explosion, spawnParticles, spawnParticles);
        return explosion;
    }

    public static void sendExplosion(Level world, AdvancedExplosion explosion, boolean smallparts, boolean bigparts) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (!world.f_46443_) {
                MsgExplosion msg = new MsgExplosion(explosion, smallparts, bigparts);
                WMMessagePipeline.sendToAround(msg, serverLevel, explosion.explosionX, explosion.explosionY, explosion.explosionZ, 64.0, (ResourceKey<Level>)world.m_46472_());
            }
        }
    }

    public static void knockBack(LivingEntity entityliving, LivingEntity attacker, float knockback) {
        entityliving.m_20256_(kbMotion);
        double dx = attacker.m_20185_() - entityliving.m_20185_();
        double dz = attacker.m_20189_() - entityliving.m_20189_();
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        entityliving.f_20918_ = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - entityliving.m_146908_();
        double f = Math.sqrt(dx * dx + dz * dz);
        Vec3 motion = entityliving.m_20184_().m_82549_(new Vec3(-dx / f * (double)knockback, (double)knockback, -dz / f * (double)knockback));
        if (motion.f_82480_ > 0.4) {
            motion = new Vec3(motion.f_82479_, 0.4, motion.f_82481_);
        }
        entityliving.m_20256_(motion);
        if (knockBackModifier > 0) {
            dx = -Math.sin(Math.toRadians(attacker.m_146908_())) * (double)knockBackModifier * 0.5;
            dz = Math.cos(Math.toRadians(attacker.m_146908_())) * (double)knockBackModifier * 0.5;
            entityliving.m_5997_(dx, 0.1, dz);
        }
        if (entityliving instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityliving;
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket((Entity)entityliving));
        }
        knockBackModifier = 0;
        kbMotion = Vec3.f_82478_;
    }

    public static void prepareKnockbackOnEntity(LivingEntity attacker, LivingEntity entity) {
        knockBackModifier = EnchantmentHelper.m_44894_((LivingEntity)attacker);
        if (attacker.m_20142_()) {
            ++knockBackModifier;
        }
        kbMotion = entity.m_20184_();
    }
}

