/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.BalkonsWeaponMod;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.player.Player;

public final class PlayerWeaponData {
    private static final EntityDataAccessor<Integer> WARHAMMER_LAST_SMASH_TICKS = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FLAIL_THROWN = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> FLAIL_ENTITY_ID = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPlayerWeaponData(Player player) {
        String playername = PlayerWeaponData.getPlayerName(player);
        BalkonsWeaponMod.LOGGER.trace("Initializing DataManager values for {}", (Object)playername);
        SynchedEntityData dataManager = player.m_20088_();
        try {
            dataManager.m_135370_(WARHAMMER_LAST_SMASH_TICKS);
            BalkonsWeaponMod.LOGGER.warn("DataManager ID conflict for {} @ {}", (Object)playername, (Object)WARHAMMER_LAST_SMASH_TICKS.m_135015_());
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            dataManager.m_135372_(WARHAMMER_LAST_SMASH_TICKS, (Object)player.f_19797_);
        }
        try {
            dataManager.m_135370_(FLAIL_THROWN);
            BalkonsWeaponMod.LOGGER.warn("DataManager ID conflict for {} @ {}", (Object)playername, (Object)FLAIL_THROWN.m_135015_());
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            dataManager.m_135372_(FLAIL_THROWN, (Object)false);
        }
        try {
            dataManager.m_135370_(FLAIL_ENTITY_ID);
            BalkonsWeaponMod.LOGGER.warn("DataManager ID conflict for {} @ {}", (Object)playername, (Object)FLAIL_ENTITY_ID.m_135015_());
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            dataManager.m_135372_(FLAIL_ENTITY_ID, (Object)0);
        }
    }

    private static String getPlayerName(Player player) {
        String playername = player.m_36316_() != null ? player.m_36316_().getName() : "[unknown]";
        return "player:" + playername;
    }

    private static void unavailableError(Player player, int id) {
        BalkonsWeaponMod.LOGGER.error("DataManager ID {} for {} unavailable, trying to reinitialize", (Object)id, (Object)PlayerWeaponData.getPlayerName(player));
        PlayerWeaponData.initPlayerWeaponData(player);
    }

    public static int getLastWarhammerSmashTicks(Player player) {
        try {
            return (Integer)player.m_20088_().m_135370_(WARHAMMER_LAST_SMASH_TICKS);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, WARHAMMER_LAST_SMASH_TICKS.m_135015_());
            return 0;
        }
    }

    public static void setLastWarhammerSmashTicks(Player player, int age) {
        try {
            player.m_20088_().m_135381_(WARHAMMER_LAST_SMASH_TICKS, (Object)age);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, WARHAMMER_LAST_SMASH_TICKS.m_135015_());
        }
    }

    public static boolean isFlailThrown(Player player) {
        try {
            return (Boolean)player.m_20088_().m_135370_(FLAIL_THROWN);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_THROWN.m_135015_());
            return false;
        }
    }

    public static void setFlailThrown(Player player, boolean flag) {
        try {
            player.m_20088_().m_135381_(FLAIL_THROWN, (Object)flag);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_THROWN.m_135015_());
        }
    }

    public static int getFlailEntityId(Player player) {
        try {
            return (Integer)player.m_20088_().m_135370_(FLAIL_ENTITY_ID);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_ENTITY_ID.m_135015_());
            return 0;
        }
    }

    public static void setFlailEntityId(Player player, int id) {
        try {
            player.m_20088_().m_135381_(FLAIL_ENTITY_ID, (Object)id);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_ENTITY_ID.m_135015_());
        }
    }
}

