/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.forge.WMItemBuilderImpl;
import ckathode.weaponmod.item.DartType;
import ckathode.weaponmod.item.ItemBlowgunDart;
import ckathode.weaponmod.item.ItemCannon;
import ckathode.weaponmod.item.ItemDummy;
import ckathode.weaponmod.item.ItemDynamite;
import ckathode.weaponmod.item.ItemFlail;
import ckathode.weaponmod.item.ItemJavelin;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.ItemMusket;
import ckathode.weaponmod.item.ItemShooter;
import ckathode.weaponmod.item.MeleeCompBattleaxe;
import ckathode.weaponmod.item.MeleeCompBoomerang;
import ckathode.weaponmod.item.MeleeCompFirerod;
import ckathode.weaponmod.item.MeleeCompHalberd;
import ckathode.weaponmod.item.MeleeCompKnife;
import ckathode.weaponmod.item.MeleeCompNone;
import ckathode.weaponmod.item.MeleeCompSpear;
import ckathode.weaponmod.item.MeleeCompWarhammer;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedCompBlowgun;
import ckathode.weaponmod.item.RangedCompBlunderbuss;
import ckathode.weaponmod.item.RangedCompCrossbow;
import ckathode.weaponmod.item.RangedCompFlintlock;
import ckathode.weaponmod.item.RangedCompMortar;
import ckathode.weaponmod.item.RangedComponent;
import ckathode.weaponmod.item.WMItem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WMItemBuilder {
    public static ItemMelee createStandardBattleaxe(@NotNull Tier tier) {
        return WMItemBuilder.createItemMelee(new MeleeCompBattleaxe(tier));
    }

    public static ItemShooter createStandardBlowgun() {
        return WMItemBuilder.createItemShooter(new RangedCompBlowgun(), new MeleeCompNone(null));
    }

    public static ItemBlowgunDart createStandardBlowgunDart(@NotNull DartType dartType) {
        return WMItemBuilder.createItemBlowgunDart(dartType);
    }

    public static ItemShooter createStandardBlunderbuss() {
        return WMItemBuilder.createItemShooter(new RangedCompBlunderbuss(), new MeleeCompNone(null));
    }

    public static ItemMelee createStandardBoomerang(@NotNull Tier tier) {
        return WMItemBuilder.createItemMelee(new MeleeCompBoomerang(tier));
    }

    public static ItemCannon createStandardCannon() {
        return WMItemBuilder.createItemCannon();
    }

    public static ItemShooter createStandardCrossbow() {
        return WMItemBuilder.createItemShooter(new RangedCompCrossbow(), new MeleeCompNone(null));
    }

    public static ItemDummy createStandardDummy() {
        return WMItemBuilder.createItemDummy();
    }

    public static ItemDynamite createStandardDynamite() {
        return WMItemBuilder.createItemDynamite();
    }

    public static ItemMelee createStandardFirerod() {
        return WMItemBuilder.createItemMelee(new MeleeCompFirerod());
    }

    public static ItemFlail createStandardFlail(@NotNull Tier tier) {
        return WMItemBuilder.createItemFlail(new MeleeCompNone(tier));
    }

    public static ItemShooter createStandardFlintlock() {
        return WMItemBuilder.createItemShooter(new RangedCompFlintlock(), new MeleeCompNone(null));
    }

    public static ItemMelee createStandardHalberd(@NotNull Tier tier) {
        return WMItemBuilder.createItemMelee(new MeleeCompHalberd(tier));
    }

    public static ItemJavelin createStandardJavelin() {
        return WMItemBuilder.createItemJavelin();
    }

    public static ItemMelee createStandardKatana(@NotNull Tier tier) {
        return WMItemBuilder.createItemMelee(new MeleeComponent(MeleeComponent.MeleeSpecs.KATANA, tier));
    }

    public static ItemMelee createStandardKnife(@NotNull Tier tier) {
        return WMItemBuilder.createItemMelee(new MeleeCompKnife(tier));
    }

    public static ItemShooter createStandardMortar() {
        return WMItemBuilder.createItemShooter(new RangedCompMortar(), new MeleeCompNone(null));
    }

    public static ItemMusket createStandardMusket() {
        return WMItemBuilder.createItemMusket();
    }

    public static ItemMusket createStandardMusketWithBayonet(@NotNull Tier tier, @NotNull Item bayonetItem) {
        return WMItemBuilder.createItemMusket(new MeleeCompKnife(tier), bayonetItem);
    }

    public static ItemMelee createStandardSpear(@NotNull Tier tier) {
        return WMItemBuilder.createItemMelee(new MeleeCompSpear(tier));
    }

    public static ItemMelee createStandardWarhammer(@NotNull Tier tier) {
        return WMItemBuilder.createItemMelee(new MeleeCompWarhammer(tier));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemBlowgunDart createItemBlowgunDart(@NotNull DartType dartType) {
        return WMItemBuilderImpl.createItemBlowgunDart(dartType);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemCannon createItemCannon() {
        return WMItemBuilderImpl.createItemCannon();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemDummy createItemDummy() {
        return WMItemBuilderImpl.createItemDummy();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemDynamite createItemDynamite() {
        return WMItemBuilderImpl.createItemDynamite();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemFlail createItemFlail(MeleeComponent meleeComponent) {
        return WMItemBuilderImpl.createItemFlail(meleeComponent);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemJavelin createItemJavelin() {
        return WMItemBuilderImpl.createItemJavelin();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemMelee createItemMelee(MeleeComponent meleeComponent) {
        return WMItemBuilderImpl.createItemMelee(meleeComponent);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemMelee createItemMelee(MeleeComponent meleeComponent, Item.Properties properties) {
        void var1_1;
        return WMItemBuilderImpl.createItemMelee(meleeComponent, (Item.Properties)var1_1);
    }

    public static ItemMusket createItemMusket() {
        return WMItemBuilder.createItemMusket(new MeleeCompNone(null), null);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemMusket createItemMusket(MeleeComponent meleeComponent, @Nullable Item bayonetItem) {
        void var1_1;
        return WMItemBuilderImpl.createItemMusket(meleeComponent, (Item)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemShooter createItemShooter(RangedComponent rangedComponent, MeleeComponent meleeComponent) {
        void var1_1;
        return WMItemBuilderImpl.createItemShooter(rangedComponent, (MeleeComponent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemShooter createItemShooter(RangedComponent rangedComponent, MeleeComponent meleeComponent, Item.Properties properties) {
        void var2_2;
        void var1_1;
        return WMItemBuilderImpl.createItemShooter(rangedComponent, (MeleeComponent)var1_1, (Item.Properties)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static WMItem createWMItem() {
        return WMItemBuilderImpl.createWMItem();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static WMItem createWMItem(Item.Properties properties) {
        return WMItemBuilderImpl.createWMItem(properties);
    }
}

