/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.entity.projectile.EntityCannonBall;
import ckathode.weaponmod.item.WMItem;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityCannon
extends Boat {
    public static final String ID = "cannon";
    public static final EntityType<EntityCannon> TYPE = WMRegistries.createEntityType("cannon", new EntityDimensions(1.5f, 1.0f, false), EntityCannon::new);
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.m_135353_(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> ROCK_DIRECTION = SynchedEntityData.m_135353_(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> CURRENT_DAMAGE = SynchedEntityData.m_135353_(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> LOADED = SynchedEntityData.m_135353_(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> LOAD_TIMER = SynchedEntityData.m_135353_(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> SUPER_POWERED = SynchedEntityData.m_135353_(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public EntityCannon(EntityType<EntityCannon> entityType, Level world) {
        super(entityType, world);
        this.f_19850_ = true;
        this.m_146926_(-20.0f);
        this.m_146922_(-180.0f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    public EntityCannon(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.m_6034_(d, d1, d2);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = d;
        this.f_19855_ = d1;
        this.f_19856_ = d2;
    }

    @NotNull
    public EntityType<?> m_6095_() {
        return TYPE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TIME_SINCE_HIT, (Object)0);
        this.f_19804_.m_135372_(ROCK_DIRECTION, (Object)1);
        this.f_19804_.m_135372_(CURRENT_DAMAGE, (Object)0);
        this.f_19804_.m_135372_(LOADED, (Object)0);
        this.f_19804_.m_135372_(LOAD_TIMER, (Object)0);
        this.f_19804_.m_135372_(SUPER_POWERED, (Object)0);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_CANNON.get());
    }

    public Item m_38369_() {
        return (Item)WMRegistries.ITEM_CANNON.get();
    }

    public boolean m_6094_() {
        return false;
    }

    public double m_6048_() {
        return 0.35;
    }

    protected boolean m_7310_(Entity passenger) {
        return !this.m_20160_() && !this.m_204029_(FluidTags.f_13131_);
    }

    public boolean m_6469_(@NotNull DamageSource damagesource, float damage) {
        Player player;
        Entity entity;
        if (this.f_19853_.f_46443_ || !this.m_6084_()) {
            return true;
        }
        if (damagesource instanceof IndirectEntityDamageSource && damagesource.m_7639_() != null) {
            if (this.m_20363_(damagesource.m_7639_())) {
                return true;
            }
        } else if (damagesource instanceof EntityDamageSource && damagesource.f_19326_.equals("player") && (entity = damagesource.m_7639_()) instanceof Player && (player = (Player)entity).m_150109_().m_36056_().m_41619_()) {
            if (!player.m_7500_()) {
                this.m_20000_((ItemLike)WMRegistries.ITEM_CANNON.get(), 1);
                if (this.isLoaded() || this.isLoading()) {
                    this.m_20000_((ItemLike)WMRegistries.ITEM_CANNON_BALL.get(), 1);
                    this.m_20000_((ItemLike)Items.f_42403_, 1);
                }
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }
        this.setRockDirection(-this.getRockDirection());
        this.m_38354_(10);
        this.setCurrentDamage(this.getCurrentDamage() + (int)damage * 5);
        this.m_5834_();
        if (this.getCurrentDamage() > 100) {
            for (int j = 0; j < 6; ++j) {
                this.dropItemWithChance(Items.f_42416_, (int)damage, 1);
            }
            this.dropItemWithChance(Items.f_42484_, (int)damage, 1);
            this.dropItemWithChance(Blocks.f_49999_.m_5456_(), (int)damage, 1);
            if (this.isLoaded() || this.isLoading()) {
                this.m_20000_((ItemLike)WMRegistries.ITEM_CANNON_BALL.get(), 1);
                this.m_20000_((ItemLike)Items.f_42403_, 1);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    public void dropItemWithChance(Item item, int chance, int amount) {
        if (this.f_19796_.nextInt(chance) < 10) {
            this.m_20000_((ItemLike)item, amount);
        }
    }

    public void m_6053_() {
        this.setRockDirection(-this.getRockDirection());
        this.m_38354_(10);
        this.setCurrentDamage(this.getCurrentDamage() + 10);
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public void m_8119_() {
        this.m_6075_();
    }

    public void m_6075_() {
        super.m_6075_();
        int i = this.m_38385_();
        if (i > 0) {
            this.m_38354_(i - 1);
        }
        if ((i = this.getCurrentDamage()) > 0) {
            this.setCurrentDamage(i - this.f_19796_.nextInt(2));
        }
        Vec3 motion = this.m_20184_().m_82492_(0.0, 0.1, 0.0);
        if (this.f_19861_) {
            motion = new Vec3(0.1 * motion.f_82479_, motion.f_82480_, 0.1 * motion.f_82481_);
        }
        motion = motion.m_82490_(0.98);
        if (!this.f_19861_) {
            this.f_19789_ += (float)(-motion.f_82480_);
        }
        this.m_20256_(motion);
        if (this.m_20160_()) {
            Entity riddenByEntity = this.m_6688_();
            float yaw = riddenByEntity.m_146908_();
            float pitch = riddenByEntity.m_146909_();
            this.m_146922_(yaw % 360.0f);
            this.m_146926_(pitch);
        }
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.m_6478_(MoverType.SELF, this.m_20184_());
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_(0.2, 0.0, 0.2), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this) || entity.m_20202_() != null) continue;
                this.m_7334_(entity);
            }
        }
        if (this.isLoading()) {
            this.setLoadTimer(this.getLoadTimer() - 1);
            this.handleReloadTime();
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        super.m_142535_(fallDistance, multiplier, source);
        int i = Mth.m_14143_((float)fallDistance);
        this.m_6469_(DamageSource.f_19315_, i *= 2);
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        if (!this.m_20159_()) {
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int j = 0; j < 5; ++j) {
                                this.m_19998_((ItemLike)Items.f_42416_);
                            }
                            this.m_19998_((ItemLike)Items.f_42484_);
                            this.m_19998_((ItemLike)Blocks.f_49999_);
                            if (this.isLoaded() || this.isLoading()) {
                                this.m_19998_((ItemLike)WMRegistries.ITEM_CANNON_BALL.get());
                                this.m_19998_((ItemLike)Items.f_42403_);
                            }
                        }
                    }
                }
                this.f_19789_ = 0.0f;
            } else if (!this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    public void handleReloadTime() {
        int l = this.getLoadTimer();
        if (l > 0) {
            if (l == 80 || l == 70 || l == 60) {
                this.m_5496_(SoundEvents.f_12311_, 0.5f, 1.2f / (this.f_19796_.nextFloat() * 0.8f + 0.6f));
            } else if (l == 40) {
                this.m_5496_(SoundEvents.f_12320_, 0.7f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 10.0f));
            }
        } else {
            this.setReloadInfo(true, 0);
        }
    }

    public void fireCannon() {
        if (!this.isLoaded()) {
            return;
        }
        Entity entityPassenger = this.m_6688_();
        if (entityPassenger != null && !this.f_19853_.f_46443_) {
            EntityCannonBall entitycannonball = new EntityCannonBall(this.f_19853_, this, entityPassenger.m_146909_(), entityPassenger.m_146908_(), this.isSuperPowered());
            this.f_19853_.m_7967_((Entity)entitycannonball);
        }
        this.setReloadInfo(false, 0);
        this.fireEffects();
    }

    public void fireEffects() {
        this.m_5496_(SoundEvents.f_11913_, 8.0f, 1.0f / (this.f_19796_.nextFloat() * 0.8f + 0.9f));
        this.m_5496_(SoundEvents.f_12090_, 8.0f, 1.0f / (this.f_19796_.nextFloat() * 0.4f + 0.6f));
        float yaw = (float)Math.toRadians(this.m_146908_());
        double d = -Mth.m_14031_((float)yaw) * -1.0f;
        double d2 = Mth.m_14089_((float)yaw) * -1.0f;
        for (int i = 0; i < 20; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + d + this.f_19796_.nextDouble() * 0.5 - 0.25, this.m_20186_() + this.f_19796_.nextDouble() * 0.5, this.m_20189_() + d2 + this.f_19796_.nextDouble() * 0.5 - 0.25, this.f_19796_.nextDouble() * 0.1 - 0.05, this.f_19796_.nextDouble() * 0.1 - 0.05, this.f_19796_.nextDouble() * 0.1 - 0.05);
        }
        if (this.m_20160_()) {
            for (Entity entity2 : this.m_20197_()) {
                entity2.m_146926_(entity2.m_146909_() + 10.0f);
            }
        }
        this.m_6469_(DamageSource.f_19318_, 2.0f);
    }

    public void setReloadInfo(boolean loaded, int reloadtime) {
        this.setLoaded(loaded);
        this.setLoadTimer(reloadtime);
    }

    public void startLoadingCannon() {
        if (this.isLoaded() && !this.isLoading()) {
            return;
        }
        this.setReloadInfo(false, 100);
    }

    public void m_7332_(@NotNull Entity passenger) {
        if (this.m_20363_(passenger)) {
            float f = -0.85f;
            float f2 = (float)((this.m_6084_() ? this.m_6048_() : 0.01) + passenger.m_6049_());
            Vec3 vec3d = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vec3d.f_82479_, this.m_20186_() + (double)f2, this.m_20189_() + vec3d.f_82481_);
        }
    }

    protected void m_7380_(CompoundTag nbttagcompound) {
        nbttagcompound.m_128350_("falld", this.f_19789_);
        nbttagcompound.m_128379_("load", this.isLoaded());
        nbttagcompound.m_128376_("ldtime", (short)this.getLoadTimer());
    }

    protected void m_7378_(CompoundTag nbttagcompound) {
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_19789_ = nbttagcompound.m_128457_("falld");
        this.setLoaded(nbttagcompound.m_128471_("load"));
        this.setLoadTimer(nbttagcompound.m_128448_("ldtime"));
    }

    @NotNull
    public InteractionResult m_6096_(Player entityplayer, @NotNull InteractionHand hand) {
        ItemStack itemstack = entityplayer.m_21120_(hand);
        if (itemstack.m_41720_() == WMRegistries.ITEM_CANNON_BALL.get() && !this.isLoaded() && !this.isLoading() && (entityplayer.m_7500_() || this.consumeAmmo(entityplayer, Items.f_42403_))) {
            if (entityplayer.m_7500_() || this.consumeAmmo(entityplayer, (Item)WMRegistries.ITEM_CANNON_BALL.get())) {
                this.startLoadingCannon();
                return InteractionResult.PASS;
            }
            this.m_20000_((ItemLike)Items.f_42403_, 1);
        } else {
            if (this.m_20160_() && this.riddenByPlayer() && this.notThisPlayer((Entity)entityplayer)) {
                return InteractionResult.PASS;
            }
            if (!this.f_19853_.f_46443_ && !entityplayer.m_6144_()) {
                entityplayer.m_20329_((Entity)this);
            }
        }
        return InteractionResult.PASS;
    }

    protected boolean consumeAmmo(Player entityplayer, Item itemAmmo) {
        return WMItem.consumeInventoryItem(entityplayer, itemAmmo);
    }

    public boolean riddenByPlayer() {
        Entity entity = this.m_6688_();
        return entity instanceof Player;
    }

    public boolean notThisPlayer(Entity player) {
        Entity entity = this.m_6688_();
        return entity != player;
    }

    public void m_8038_(@NotNull ServerLevel world, @NotNull LightningBolt entitylightningbolt) {
        this.m_6469_(DamageSource.f_19306_, 100.0f);
        this.setSuperPowered(true);
    }

    public void setLoaded(boolean flag) {
        this.f_19804_.m_135381_(LOADED, (Object)((byte)(flag ? 1 : 0)));
    }

    public void setLoadTimer(int time) {
        this.f_19804_.m_135381_(LOAD_TIMER, (Object)time);
    }

    public void setSuperPowered(boolean flag) {
        this.f_19804_.m_135381_(SUPER_POWERED, (Object)((byte)(flag ? 1 : 0)));
    }

    public boolean isLoading() {
        return this.getLoadTimer() > 0;
    }

    public boolean isLoaded() {
        return (Byte)this.f_19804_.m_135370_(LOADED) != 0;
    }

    public int getLoadTimer() {
        return (Integer)this.f_19804_.m_135370_(LOAD_TIMER);
    }

    public boolean isSuperPowered() {
        return (Byte)this.f_19804_.m_135370_(SUPER_POWERED) != 0;
    }

    public void m_38354_(int i) {
        this.f_19804_.m_135381_(TIME_SINCE_HIT, (Object)i);
    }

    public void setRockDirection(int i) {
        this.f_19804_.m_135381_(ROCK_DIRECTION, (Object)((byte)i));
    }

    public void setCurrentDamage(int i) {
        this.f_19804_.m_135381_(CURRENT_DAMAGE, (Object)i);
    }

    public int m_38385_() {
        return (Integer)this.f_19804_.m_135370_(TIME_SINCE_HIT);
    }

    public int getRockDirection() {
        return ((Byte)this.f_19804_.m_135370_(ROCK_DIRECTION)).byteValue();
    }

    public int getCurrentDamage() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_DAMAGE);
    }
}

