/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.item.IItemWeapon;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityDummy
extends Entity {
    public static final String ID = "dummy";
    public static final EntityType<EntityDummy> TYPE = WMRegistries.createEntityType("dummy", new EntityDimensions(0.5f, 1.9f, false), 4, 20, EntityDummy::new);
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.m_135353_(EntityDummy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> ROCK_DIRECTION = SynchedEntityData.m_135353_(EntityDummy.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> CURRENT_DAMAGE = SynchedEntityData.m_135353_(EntityDummy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int durability;

    public EntityDummy(EntityType<EntityDummy> entityType, Level world) {
        super(entityType, world);
        this.f_19850_ = true;
        this.m_146926_(-20.0f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.durability = 50;
    }

    public EntityDummy(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.m_6034_(d, d1, d2);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = d;
        this.f_19855_ = d1;
        this.f_19856_ = d2;
    }

    @NotNull
    public EntityType<?> m_6095_() {
        return TYPE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TIME_SINCE_HIT, (Object)0);
        this.f_19804_.m_135372_(ROCK_DIRECTION, (Object)1);
        this.f_19804_.m_135372_(CURRENT_DAMAGE, (Object)0);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_DUMMY.get());
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource damagesource, float damage) {
        if (this.f_19853_.f_46443_ || !this.m_6084_() || damage <= 0.0f) {
            return false;
        }
        this.setRockDirection(-this.getRockDirection());
        this.setTimeSinceHit(10);
        int i = this.getCurrentDamage();
        if ((i += (int)(damage * 5.0f)) > 50) {
            i = 50;
        }
        this.setCurrentDamage(i);
        this.m_5834_();
        if (!(damagesource instanceof EntityDamageSource)) {
            this.durability -= (int)damage;
        } else if (damagesource instanceof WeaponDamageSource) {
            WeaponDamageSource wds = (WeaponDamageSource)damagesource;
            Entity entity = wds.getProjectile();
            if (entity.m_20184_().m_82553_() > 0.5) {
                entity.m_20256_(entity.m_20184_().m_82490_((double)0.1f));
                this.playRandomHitSound();
            } else {
                entity.m_20334_((double)(this.f_19796_.nextFloat() - 0.5f), (double)(this.f_19796_.nextFloat() - 0.5f), (double)(this.f_19796_.nextFloat() - 0.5f));
            }
        } else {
            this.playRandomHitSound();
        }
        if (this.durability <= 0 && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.dropAsItem(true, true);
        }
        this.m_5834_();
        return false;
    }

    public void playRandomHitSound() {
        int i = this.f_19796_.nextInt(2);
        if (i == 0) {
            this.m_5496_(SoundEvents.f_12591_, 0.7f, 1.0f / (this.f_19796_.nextFloat() * 0.2f + 0.4f));
        } else {
            this.m_5496_(SoundEvents.f_12638_, 0.7f, 1.0f / (this.f_19796_.nextFloat() * 0.2f + 0.2f));
        }
    }

    public void m_6053_() {
        this.setRockDirection(-this.getRockDirection());
        this.setTimeSinceHit(10);
        this.setCurrentDamage(this.getCurrentDamage() + 10);
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public void m_8119_() {
        super.m_8119_();
        int i = this.getTimeSinceHit();
        if (i > 0) {
            this.setTimeSinceHit(i - 1);
        }
        if ((i = this.getCurrentDamage()) > 0) {
            this.setCurrentDamage(i - this.f_19796_.nextInt(2));
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.f_19861_) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            Vec3 motion = this.m_20184_();
            double motionX = motion.f_82479_ * 0.99;
            double motionZ = motion.f_82481_ * 0.99;
            double motionY = motion.f_82480_ - 0.05;
            this.f_19789_ += (float)(-motionY);
            this.m_20334_(motionX, motionY, motionZ);
        }
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.m_6478_(MoverType.SELF, new Vec3(0.0, this.m_20184_().f_82480_, 0.0));
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_(0.2, 0.0, 0.2), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this)) continue;
                this.m_7334_(entity);
            }
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        super.m_142535_(fallDistance, multiplier, source);
        if (!this.f_19861_) {
            return false;
        }
        int i = Mth.m_14143_((float)fallDistance);
        this.m_6469_(DamageSource.f_19315_, i);
        return false;
    }

    public void dropAsItem(boolean destroyed, boolean noCreative) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (destroyed) {
            for (int i = 0; i < this.f_19796_.nextInt(8); ++i) {
                this.m_20000_((ItemLike)Items.f_42454_, 1);
            }
        } else if (noCreative) {
            this.m_20000_((ItemLike)WMRegistries.ITEM_DUMMY.get(), 1);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @NotNull
    public InteractionResult m_6096_(Player entityplayer, @NotNull InteractionHand hand) {
        ItemStack itemstack = entityplayer.m_150109_().m_36056_();
        if (!itemstack.m_41619_() && (itemstack.m_41720_() instanceof IItemWeapon || itemstack.m_41720_() instanceof SwordItem || itemstack.m_41720_() instanceof BowItem || itemstack.m_41720_() instanceof ShieldItem)) {
            return InteractionResult.FAIL;
        }
        if (entityplayer.m_7500_()) {
            this.dropAsItem(false, false);
            return InteractionResult.SUCCESS;
        }
        this.dropAsItem(false, true);
        return InteractionResult.SUCCESS;
    }

    protected void m_7380_(@NotNull CompoundTag nbttagcompound) {
    }

    protected void m_7378_(@NotNull CompoundTag nbttagcompound) {
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    public void setTimeSinceHit(int i) {
        this.f_19804_.m_135381_(TIME_SINCE_HIT, (Object)i);
    }

    public void setRockDirection(int i) {
        this.f_19804_.m_135381_(ROCK_DIRECTION, (Object)((byte)i));
    }

    public void setCurrentDamage(int i) {
        this.f_19804_.m_135381_(CURRENT_DAMAGE, (Object)i);
    }

    public int getTimeSinceHit() {
        return (Integer)this.f_19804_.m_135370_(TIME_SINCE_HIT);
    }

    public int getRockDirection() {
        return ((Byte)this.f_19804_.m_135370_(ROCK_DIRECTION)).byteValue();
    }

    public int getCurrentDamage() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_DAMAGE);
    }
}

