/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.DartType;
import ckathode.weaponmod.item.ItemBlowgunDart;
import dev.architectury.networking.NetworkManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityBlowgunDart
extends EntityProjectile<EntityBlowgunDart> {
    private static final EntityDataAccessor<Byte> DART_EFFECT_TYPE = SynchedEntityData.m_135353_(EntityBlowgunDart.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final float[][] DART_COLORS = new float[][]{{0.2f, 0.8f, 0.3f}, {0.9f, 0.7f, 1.0f}, {0.6f, 1.0f, 0.9f}, {0.8f, 0.5f, 0.2f}};
    public static final String ID = "dart";
    public static final EntityType<EntityBlowgunDart> TYPE = WMRegistries.createEntityType("dart", new EntityDimensions(0.5f, 0.5f, false), EntityBlowgunDart::new);

    public EntityBlowgunDart(EntityType<EntityBlowgunDart> entityType, Level world) {
        super(entityType, world);
    }

    public EntityBlowgunDart(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        this.m_6034_(d, d1, d2);
    }

    public EntityBlowgunDart(Level world, LivingEntity shooter) {
        this(world, shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void m_37251_(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, f3, f4);
        Vec3 entityMotion = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(entityMotion.f_82479_, entity.m_20096_() ? 0.0 : entityMotion.f_82480_, entityMotion.f_82481_));
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DART_EFFECT_TYPE, (Object)0);
    }

    public void setDartEffectType(DartType type) {
        this.setDartEffectType(type.typeID());
    }

    public void setDartEffectType(byte i) {
        this.f_19804_.m_135381_(DART_EFFECT_TYPE, (Object)i);
    }

    public DartType getDartEffectType() {
        return DartType.dartTypes[this.getDartEffectId()];
    }

    public byte getDartEffectId() {
        byte effectId = (Byte)this.f_19804_.m_135370_(DART_EFFECT_TYPE);
        if (effectId < 0) {
            effectId = 0;
        }
        return effectId;
    }

    public float[] getDartColor() {
        byte effectId = this.getDartEffectId();
        return DART_COLORS[effectId >= DART_COLORS.length ? (byte)0 : effectId];
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        DamageSource damagesource;
        Entity entity = result.m_82443_();
        if (entity.m_6469_(damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity()), 1.0f + this.extraDamage)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(this.getDartEffectType().potionEffect()));
            }
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public float getGravity() {
        return 0.05f;
    }

    @Override
    public void playHitSound() {
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.2f));
    }

    @Override
    public int getMaxArrowShake() {
        return 4;
    }

    @Override
    @NotNull
    public ItemStack m_7941_() {
        return new ItemStack((ItemLike)ItemBlowgunDart.ITEMS.get(this.getDartEffectType()));
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128344_("darttype", this.getDartEffectId());
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setDartEffectType(nbttagcompound.m_128445_("darttype"));
    }
}

