/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.RangedComponent;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityBlunderShot
extends EntityProjectile<EntityBlunderShot> {
    public static final String ID = "shot";
    public static final EntityType<EntityBlunderShot> TYPE = WMRegistries.createEntityType("shot", new EntityDimensions(0.5f, 0.5f, false), EntityBlunderShot::new);

    public EntityBlunderShot(EntityType<EntityBlunderShot> entityType, Level world) {
        super(entityType, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
    }

    public EntityBlunderShot(Level world, double x, double y, double z) {
        this(TYPE, world);
        this.m_6034_(x, y, z);
    }

    public EntityBlunderShot(Level world, LivingEntity shooter) {
        this(world, shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void m_37251_(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, f3, f4);
        Vec3 entityMotion = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(entityMotion.f_82479_, entity.m_20096_() ? 0.0 : entityMotion.f_82480_, entityMotion.f_82481_));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.ticksInAir > 4) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        float damage = 4.0f + this.extraDamage;
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        int prevhurtrestime = entity.f_19802_;
        if (entity.m_6469_(damagesource, damage)) {
            entity.f_19802_ = prevhurtrestime;
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxLifetime() {
        return 200;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float getGravity() {
        return this.getTotalVelocity() < 2.0 ? 0.04f : 0.0f;
    }

    @Override
    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_BLUNDER_SHOT.get());
    }

    public static void fireSpreadShot(Level world, LivingEntity entityliving, RangedComponent item, ItemStack itemstack) {
        for (int i = 0; i < 10; ++i) {
            EntityBlunderShot entity = new EntityBlunderShot(world, entityliving);
            entity.m_37251_((Entity)entityliving, entityliving.m_146909_(), entityliving.m_146908_(), 0.0f, 5.0f, 15.0f);
            if (item != null && !itemstack.m_41619_()) {
                item.applyProjectileEnchantments(entity, itemstack);
            }
            world.m_7967_((Entity)entity);
        }
    }

    public static void fireFromDispenser(Level world, double d, double d1, double d2, int i, int j, int k) {
        for (int i2 = 0; i2 < 10; ++i2) {
            EntityBlunderShot entityblundershot = new EntityBlunderShot(world, d, d1, d2);
            entityblundershot.m_6686_(i, j, k, 5.0f, 15.0f);
            world.m_7967_((Entity)entityblundershot);
        }
    }
}

