/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.IItemWeapon;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityBoomerang
extends EntityMaterialProjectile<EntityBoomerang> {
    public static final String ID = "boomerang";
    public static final EntityType<EntityBoomerang> TYPE = WMRegistries.createEntityType("boomerang", new EntityDimensions(0.5f, 0.5f, false), EntityBoomerang::new);
    private static final EntityDataAccessor<Float> BOOMERANG = SynchedEntityData.m_135353_(EntityBoomerang.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final double RETURN_STRENGTH = 0.05;
    public static final float MIN_FLOAT_STRENGTH = 0.4f;
    private float soundTimer;
    public float floatStrength;

    public EntityBoomerang(EntityType<EntityBoomerang> entityType, Level world) {
        super(entityType, world);
    }

    public EntityBoomerang(Level world, double x, double y, double z) {
        this(TYPE, world);
        this.m_6034_(x, y, z);
    }

    public EntityBoomerang(Level world, LivingEntity shooter, ItemStack itemstack) {
        this(world, shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
        this.soundTimer = 0.0f;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void m_37251_(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, f3, f4);
        Vec3 entityMotion = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(entityMotion.f_82479_, entity.m_20096_() ? 0.0 : entityMotion.f_82480_, entityMotion.f_82481_));
        this.floatStrength = Math.min(1.5f, f3);
        this.f_19804_.m_135381_(BOOMERANG, (Object)Float.valueOf(this.floatStrength));
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOOMERANG, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_8119_() {
        Entity shooter;
        super.m_8119_();
        this.floatStrength = ((Float)this.f_19804_.m_135370_(BOOMERANG)).floatValue();
        if (this.inGround) {
            return;
        }
        this.floatStrength *= 0.994f;
        if (this.floatStrength < 0.4f) {
            if (this.m_36792_()) {
                this.m_36762_(false);
            }
            this.floatStrength = 0.0f;
        }
        float limitedStrength = Math.min(1.0f, this.floatStrength);
        if (!this.beenInGround) {
            this.m_146922_(this.m_146908_() + 20.0f * this.floatStrength);
        }
        if (!this.beenInGround && (shooter = this.m_37282_()) != null && this.floatStrength > 0.0f) {
            Vec3 d = this.m_20182_().m_82546_(shooter.m_20182_()).m_82492_(0.0, (double)shooter.m_20192_(), 0.0).m_82541_();
            this.m_20256_(this.m_20184_().m_82546_(d.m_82490_(0.05)));
            this.soundTimer += limitedStrength;
            if (this.soundTimer > 3.0f) {
                this.m_5496_(SoundEvents.f_11687_, 0.6f, 1.0f / (this.f_19796_.nextFloat() * 0.2f + 2.2f - limitedStrength));
                this.soundTimer %= 3.0f;
            }
        }
        this.f_19804_.m_135381_(BOOMERANG, (Object)Float.valueOf(this.floatStrength));
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        Item item;
        Entity shooter;
        if (this.f_19853_.f_46443_ || this.floatStrength < 0.4f) {
            return;
        }
        Entity entity = result.m_82443_();
        if (entity == (shooter = this.m_37282_())) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack item2 = this.m_7941_();
                if (item2.m_41619_()) {
                    return;
                }
                if (player.m_7500_() || player.m_150109_().m_36054_(item2)) {
                    this.m_5496_(SoundEvents.f_12019_, 0.2f, ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.onItemPickup(player);
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            return;
        }
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem.m_41619_() || !((item = thrownItem.m_41720_()) instanceof IItemWeapon)) {
            return;
        }
        IItemWeapon iiw = (IItemWeapon)item;
        float damage = iiw.getMeleeComponent().getEntityDamage() + 2.0f + this.extraDamage;
        damage += this.getMeleeHitDamage(entity);
        if (this.m_36792_()) {
            damage += 2.0f;
        }
        if (entity.m_6469_(damagesource, damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            if (thrownItem.m_41773_() + 1 >= thrownItem.m_41776_()) {
                thrownItem.m_41774_(1);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                ServerPlayer sp;
                thrownItem.m_41629_(1, this.f_19796_, shooter instanceof ServerPlayer ? (sp = (ServerPlayer)shooter) : null);
                this.m_6001_(0.0, 0.0, 0.0);
            }
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void m_8060_(BlockHitResult result) {
        BlockPos blockpos = result.m_82425_();
        this.xTile = blockpos.m_123341_();
        this.yTile = blockpos.m_123342_();
        this.zTile = blockpos.m_123343_();
        this.inBlockState = this.f_19853_.m_8055_(blockpos);
        Vec3 motion = result.m_82450_().m_82546_(this.m_20182_());
        this.m_20256_(motion);
        Vec3 newPos = this.m_20182_().m_82546_(motion.m_82541_().m_82490_(0.05));
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        this.m_20334_((double)(-this.f_19796_.nextFloat() * 0.5f) * motion.f_82479_, this.f_19796_.nextFloat() * 0.1f, (double)(-this.f_19796_.nextFloat() * 0.5f) * motion.f_82481_);
        this.inGround = result.m_82434_() == Direction.UP;
        this.m_36762_(false);
        this.beenInGround = true;
        this.floatStrength = 0.0f;
        if (this.inBlockState != null) {
            this.inBlockState.m_60682_(this.f_19853_, blockpos, (Entity)this);
        }
    }

    @Override
    public void playHitSound() {
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.0f / (this.f_19796_.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public boolean aimRotation() {
        return this.beenInGround || this.floatStrength < 0.4f;
    }

    @Override
    public int getMaxLifetime() {
        return this.pickupStatus == EntityProjectile.PickupStatus.ALLOWED || this.pickupStatus == EntityProjectile.PickupStatus.OWNER_ONLY ? 0 : 1200;
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float getGravity() {
        return this.beenInGround || this.floatStrength < 0.4f ? 0.05f : 0.0f;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public void m_6123_(@NotNull Player entityplayer) {
        if (!this.beenInGround && this.ticksInAir > 5 && !this.f_19853_.f_46443_ && this.floatStrength >= 0.4f && entityplayer.equals((Object)this.m_37282_())) {
            ItemStack item = this.m_7941_();
            if (item.m_41619_()) {
                return;
            }
            if (entityplayer.m_7500_() || entityplayer.m_150109_().m_36054_(item)) {
                this.m_5496_(SoundEvents.f_12019_, 0.2f, ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
        super.m_6123_(entityplayer);
    }
}

