/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityCannonBall
extends EntityProjectile<EntityCannonBall> {
    public static final String ID = "cannonball";
    public static final EntityType<EntityCannonBall> TYPE = WMRegistries.createEntityType("cannonball", new EntityDimensions(0.5f, 0.5f, false), EntityCannonBall::new);

    public EntityCannonBall(EntityType<EntityCannonBall> entityType, Level world) {
        super(entityType, world);
    }

    public EntityCannonBall(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.m_6034_(d, d1, d2);
    }

    public EntityCannonBall(Level world, EntityCannon entitycannon, float f, float f1, boolean superPowered) {
        this(world, entitycannon.m_20185_(), entitycannon.m_20186_() + 1.0, entitycannon.m_20189_());
        Entity entityPassenger = entitycannon.m_20197_().isEmpty() ? null : (Entity)entitycannon.m_20197_().get(0);
        this.m_5602_((Entity)entitycannon);
        if (entityPassenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityPassenger;
            this.setPickupStatusFromEntity(livingEntity);
        } else {
            this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        }
        float x = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, superPowered ? 4.0f : 2.0f, superPowered ? 0.1f : 2.0f);
        Vec3 cannonMotion = entitycannon.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(cannonMotion.f_82479_, 0.0, cannonMotion.f_82481_));
        this.m_36762_(superPowered);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        double speed = this.m_20184_().m_82553_();
        double amount = 8.0;
        if (speed > 1.0) {
            Vec3 motion = this.m_20184_();
            int i1 = 1;
            while ((double)i1 < amount) {
                Vec3 pos = this.m_20182_().m_82549_(motion.m_82490_((double)i1 / amount));
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
                ++i1;
            }
        }
    }

    public void createCrater() {
        if (this.f_19853_.f_46443_ || !this.inGround || this.m_20069_()) {
            return;
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        float f = this.m_36792_() ? 5.0f : 2.5f;
        PhysHelper.createAdvancedExplosion(this.f_19853_, (Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), f, WeaponModConfig.get().cannonDoesBlockDamage, true, false, Explosion.BlockInteraction.DESTROY);
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        if (result.m_82443_().m_6469_(damagesource, 30.0f)) {
            this.m_5496_(SoundEvents.f_12323_, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.4f + 0.7f));
        }
    }

    @Override
    public void m_8060_(BlockHitResult result) {
        BlockPos blockpos = result.m_82425_();
        this.xTile = blockpos.m_123341_();
        this.yTile = blockpos.m_123342_();
        this.zTile = blockpos.m_123343_();
        this.inBlockState = this.f_19853_.m_8055_(blockpos);
        this.m_20256_(result.m_82450_().m_82546_(this.m_20182_()));
        double f1 = this.m_20184_().m_82553_();
        Vec3 pos = this.m_20182_().m_82546_(this.m_20184_().m_82490_(0.05 / f1));
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.inGround = true;
        if (this.inBlockState != null) {
            this.inBlockState.m_60682_(this.f_19853_, blockpos, (Entity)this);
        }
        this.createCrater();
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public float getGravity() {
        return 0.04f;
    }

    @Override
    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_CANNON_BALL.get());
    }
}

