/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityDynamite
extends EntityProjectile<EntityDynamite> {
    public static final String ID = "dynamite";
    public static final EntityType<EntityDynamite> TYPE = WMRegistries.createEntityType("dynamite", new EntityDimensions(0.5f, 0.5f, false), EntityDynamite::new);
    private int explodefuse;
    private boolean extinguished;

    public EntityDynamite(EntityType<EntityDynamite> entityType, Level world) {
        super(entityType, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        this.extinguished = false;
        this.explodefuse = this.f_19796_.nextInt(30) + 20;
    }

    public EntityDynamite(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.m_6034_(d, d1, d2);
    }

    public EntityDynamite(Level world, LivingEntity shooter, int i) {
        this(world, shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        this.explodefuse = i;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void m_37251_(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, f3, f4);
        Vec3 entityMotion = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(entityMotion.f_82479_, entity.m_20096_() ? 0.0 : entityMotion.f_82480_, entityMotion.f_82481_));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.inGround && !this.beenInGround) {
            this.m_146926_(this.m_146909_() - 50.0f);
            if (this.m_146909_() <= -360.0f) {
                this.m_146926_(this.m_146909_() + 360.0f);
            }
        } else {
            this.f_19860_ = 180.0f;
            this.m_146926_(this.f_19860_);
        }
        if (this.m_20069_() && !this.extinguished) {
            this.extinguished = true;
            this.m_5496_(SoundEvents.f_11914_, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
            for (int k = 0; k < 8; ++k) {
                float f6 = 0.25f;
                Vec3 motion = this.m_20184_();
                Vec3 pos = this.m_20182_().m_82546_(motion.m_82490_((double)f6));
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
        --this.explodefuse;
        if (!this.extinguished) {
            if (this.explodefuse <= 0) {
                this.detonate();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        DamageSource damagesource;
        Entity entity = result.m_82443_();
        if (entity.m_6469_(damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity()), 1.0f)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.m_6001_(0.0, 0.0, 0.0);
            this.ticksInAir = 0;
        }
    }

    @Override
    public void m_8060_(BlockHitResult result) {
        BlockPos blockpos = result.m_82425_();
        this.xTile = blockpos.m_123341_();
        this.yTile = blockpos.m_123342_();
        this.zTile = blockpos.m_123343_();
        this.inBlockState = this.f_19853_.m_8055_(blockpos);
        Vec3 motion = result.m_82450_().m_82546_(this.m_20182_());
        this.m_20256_(motion);
        Vec3 newPos = this.m_20182_().m_82546_(motion.m_82541_().m_82490_(0.05));
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        this.m_20334_(-0.2 * motion.f_82479_, motion.f_82480_, -0.2 * motion.f_82481_);
        if (result.m_82434_() == Direction.UP) {
            this.inGround = true;
            this.beenInGround = true;
        } else {
            this.inGround = false;
            this.m_5496_(SoundEvents.f_11914_, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
        }
        if (this.inBlockState != null) {
            this.inBlockState.m_60682_(this.f_19853_, blockpos, (Entity)this);
        }
    }

    private void detonate() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.extinguished && (this.ticksInGround >= 200 || this.ticksInAir >= 200)) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        float f = 2.0f;
        PhysHelper.createAdvancedExplosion(this.f_19853_, (Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), f, WeaponModConfig.get().dynamiteDoesBlockDamage, true, false, Explosion.BlockInteraction.DESTROY);
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_DYNAMITE.get());
    }

    @Override
    public void playHitSound() {
        this.m_5496_(SoundEvents.f_11914_, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128344_("fuse", (byte)this.explodefuse);
        nbttagcompound.m_128379_("off", this.extinguished);
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.explodefuse = nbttagcompound.m_128445_("fuse");
        this.extinguished = nbttagcompound.m_128471_("off");
    }
}

