/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.item.ItemFlail;
import dev.architectury.networking.NetworkManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityFlail
extends EntityMaterialProjectile<EntityFlail> {
    public static final String ID = "flail";
    public static final EntityType<EntityFlail> TYPE = WMRegistries.createEntityType("flail", new EntityDimensions(0.5f, 0.5f, false), EntityFlail::new);
    public boolean isSwinging;
    private float flailDamage;
    private Vec3 distance;

    public EntityFlail(EntityType<EntityFlail> entityType, Level world) {
        super(entityType, world);
        this.f_19811_ = true;
        this.flailDamage = 1.0f;
        this.distance = Vec3.f_82478_;
    }

    public EntityFlail(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.m_6034_(d, d1, d2);
    }

    public EntityFlail(Level worldIn, LivingEntity shooter, ItemStack itemstack) {
        this(worldIn, shooter.m_20185_(), shooter.m_20188_() - 0.3, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void m_37251_(Entity entity, float f, float f1, float f2, float f3, float f4) {
        Vec3 entityMotion = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(entityMotion.f_82479_, entity.m_20096_() ? 0.0 : entityMotion.f_82480_, entityMotion.f_82481_));
        this.swing(f, f1, f3, f4);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity shooter = this.m_37282_();
        if (shooter != null) {
            this.distance = shooter.m_20182_().m_82546_(this.m_20182_());
            if (this.distance.m_82556_() > 9.0) {
                this.returnToOwner(true);
            }
            if (shooter instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)shooter;
                ItemStack itemstack = livingEntity.m_21205_();
                ItemStack thrownItem = this.getWeapon();
                if (itemstack.m_41619_() || !thrownItem.m_41619_() && itemstack.m_41720_() != thrownItem.m_41720_() || !shooter.m_6084_()) {
                    this.pickUpByOwner();
                }
            }
        } else if (!this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.inGround) {
            this.inGround = false;
            return;
        }
        this.returnToOwner(false);
    }

    public void returnToOwner(boolean looseFromGround) {
        Entity shooter;
        if (looseFromGround) {
            this.inGround = false;
        }
        if ((shooter = this.m_37282_()) == null) {
            return;
        }
        double targetPosX = shooter.m_20185_();
        double targetPosY = shooter.m_142469_().f_82289_ + (double)0.4f;
        double targetPosZ = shooter.m_20189_();
        float f = 27.0f;
        float f2 = 2.0f;
        this.distance = new Vec3(targetPosX += -Math.sin((shooter.m_146908_() + f) * ((float)Math.PI / 180)) * Math.cos(shooter.m_146909_() * ((float)Math.PI / 180)) * (double)f2, targetPosY, targetPosZ += Math.cos((shooter.m_146908_() + f) * ((float)Math.PI / 180)) * Math.cos(shooter.m_146909_() * ((float)Math.PI / 180)) * (double)f2).m_82546_(this.m_20182_());
        double distanceTotalSqr = this.distance.m_82556_();
        if (distanceTotalSqr > 9.0) {
            this.m_6034_(targetPosX, targetPosY, targetPosZ);
        } else if (distanceTotalSqr > 6.25) {
            this.isSwinging = false;
            this.m_20256_(this.m_20184_().m_82490_(-0.5));
        }
        if (!this.isSwinging) {
            float f3 = 0.2f;
            this.m_20256_(this.distance.m_82490_((double)f3 * Math.sqrt(distanceTotalSqr)));
        }
    }

    public void pickUpByOwner() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        Entity shooter = this.m_37282_();
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (!this.getWeapon().m_41619_()) {
                PlayerWeaponData.setFlailThrown(player, false);
            }
        }
    }

    public void swing(float f, float f1, float f2, float f3) {
        if (this.isSwinging) {
            return;
        }
        this.m_5496_(SoundEvents.f_11687_, 0.5f, 0.4f / (this.f_19796_.nextFloat() * 0.4f + 0.8f));
        float x = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, f2, f3);
        this.isSwinging = true;
        this.inGround = false;
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        DamageSource damagesource;
        Entity entity = result.m_82443_();
        if (entity.equals((Object)this.m_37282_())) {
            return;
        }
        Entity shooter = this.getDamagingEntity();
        if (shooter instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)shooter;
            v0 = DamageSource.m_19370_((LivingEntity)livingEntity);
        } else {
            v0 = damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, shooter);
        }
        if (entity.m_6469_(damagesource, this.flailDamage + this.extraDamage)) {
            this.playHitSound();
            this.returnToOwner(true);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void bounceBack() {
        this.m_20256_(this.m_20184_().m_82490_(-0.8));
        this.m_146922_(this.m_146908_() + 180.0f);
        this.f_19859_ += 180.0f;
        this.ticksInAir = 0;
    }

    @Override
    public void playHitSound() {
        if (this.inGround) {
            return;
        }
        this.m_5496_(SoundEvents.f_12323_, 1.0f, this.f_19796_.nextFloat() * 0.4f + 0.8f);
    }

    @Override
    public void setThrownItemStack(@NotNull ItemStack itemstack) {
        if (itemstack.m_41619_() || itemstack.m_41720_() instanceof ItemFlail) {
            super.setThrownItemStack(itemstack);
            Item item = itemstack.m_41720_();
            if (item instanceof ItemFlail) {
                ItemFlail flail = (ItemFlail)item;
                this.flailDamage = flail.getFlailDamage();
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128350_("fDmg", this.flailDamage);
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.flailDamage = nbttagcompound.m_128457_("fDmg");
    }

    @Override
    public void m_6123_(@NotNull Player entityplayer) {
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }
}

