/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityJavelin
extends EntityProjectile<EntityJavelin> {
    public static final String ID = "javelin";
    public static final EntityType<EntityJavelin> TYPE = WMRegistries.createEntityType("javelin", new EntityDimensions(0.5f, 0.5f, false), EntityJavelin::new);

    public EntityJavelin(EntityType<EntityJavelin> entityType, Level world) {
        super(entityType, world);
    }

    public EntityJavelin(Level world, double x, double y, double z) {
        this(TYPE, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        this.m_6034_(x, y, z);
    }

    public EntityJavelin(Level world, LivingEntity shooter) {
        this(world, shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void m_37251_(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, f3 * 1.1f, f4);
        Vec3 entityMotion = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(entityMotion.f_82479_, entity.m_20096_() ? 0.0 : entityMotion.f_82480_, entityMotion.f_82481_));
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        DamageSource damagesource;
        Entity entity;
        double vel = this.getTotalVelocity();
        int damage = Mth.m_14165_((double)(vel * (3.0 + (double)this.extraDamage)));
        if (this.m_36792_()) {
            damage += this.f_19796_.nextInt(damage / 2 + 2);
        }
        if ((entity = result.m_82443_()).m_6469_(damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity()), (float)damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void playHitSound() {
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.0f / (this.f_19796_.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public int getMaxArrowShake() {
        return 10;
    }

    @Override
    public float getGravity() {
        return 0.03f;
    }

    @Override
    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_JAVELIN.get());
    }
}

