/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.entity.projectile.MaterialRegistry;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.ItemHitEffect;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EntityMaterialProjectile<T extends EntityMaterialProjectile<T>>
extends EntityProjectile<T> {
    private static final EntityDataAccessor<Integer> WEAPON_MATERIAL = SynchedEntityData.m_135353_(EntityMaterialProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> WEAPON_ITEM = SynchedEntityData.m_135353_(EntityMaterialProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final float[][] MATERIAL_COLORS = new float[][]{{0.6f, 0.4f, 0.1f}, {0.5f, 0.5f, 0.5f}, {1.0f, 1.0f, 1.0f}, {0.0f, 0.8f, 0.7f}, {1.0f, 0.9f, 0.0f}, {0.3f, 0.3f, 0.3f}};

    public EntityMaterialProjectile(EntityType<T> type, Level world) {
        super(type, world);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WEAPON_MATERIAL, (Object)0);
        this.f_19804_.m_135372_(WEAPON_ITEM, (Object)ItemStack.f_41583_);
    }

    @Override
    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        super.saveAdditionalSpawnData(buf);
        buf.writeInt(this.getWeaponMaterialId());
        buf.m_130055_(this.getWeapon());
    }

    @Override
    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        super.loadAdditionalSpawnData(buf);
        this.f_19804_.m_135381_(WEAPON_MATERIAL, (Object)buf.readInt());
        this.f_19804_.m_135381_(WEAPON_ITEM, (Object)buf.m_130267_());
    }

    public float getMeleeHitDamage(Entity entity) {
        Entity shooter = this.m_37282_();
        if (shooter instanceof LivingEntity) {
            LivingEntity livingShooter = (LivingEntity)shooter;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return EnchantmentHelper.m_44833_((ItemStack)livingShooter.m_21205_(), (MobType)livingEntity.m_6336_());
            }
        }
        return 0.0f;
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        Item item;
        super.m_5790_(result);
        ItemStack thrownItem = this.getWeapon();
        if (!thrownItem.m_41619_() && (item = thrownItem.m_41720_()) instanceof ItemHitEffect) {
            ItemHitEffect ihe = (ItemHitEffect)item;
            ihe.onHitEntity(this, result);
        }
    }

    @Override
    public void m_8060_(BlockHitResult result) {
        Item item;
        super.m_8060_(result);
        ItemStack thrownItem = this.getWeapon();
        if (!thrownItem.m_41619_() && (item = thrownItem.m_41720_()) instanceof ItemHitEffect) {
            ItemHitEffect ihe = (ItemHitEffect)item;
            ihe.onHitBlock(this, result);
        }
    }

    @Override
    public void applyEntityHitEffects(Entity entity) {
        super.applyEntityHitEffects(entity);
        Entity shooter = this.m_37282_();
        if (shooter instanceof LivingEntity) {
            LivingEntity livingShooter = (LivingEntity)shooter;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int i = EnchantmentHelper.m_44894_((LivingEntity)livingShooter);
                if (i != 0) {
                    livingEntity.m_147240_((double)((float)i * 0.4f), (double)(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                }
                if ((i = EnchantmentHelper.m_44914_((LivingEntity)livingShooter)) > 0 && !entity.m_6060_()) {
                    entity.m_20254_(1);
                }
            }
        }
    }

    public void setThrownItemStack(@NotNull ItemStack itemstack) {
        this.f_19804_.m_135381_(WEAPON_ITEM, (Object)itemstack);
        this.updateWeaponMaterial();
    }

    @Override
    @NotNull
    public ItemStack m_7941_() {
        return this.getWeapon();
    }

    public int getWeaponMaterialId() {
        return (Integer)this.f_19804_.m_135370_(WEAPON_MATERIAL);
    }

    @NotNull
    public ItemStack getWeapon() {
        return (ItemStack)this.f_19804_.m_135370_(WEAPON_ITEM);
    }

    protected void updateWeaponMaterial() {
        IItemWeapon weapon;
        Item item;
        ItemStack thrownItem = this.getWeapon();
        if (!thrownItem.m_41619_() && (item = thrownItem.m_41720_()) instanceof IItemWeapon && (weapon = (IItemWeapon)item).getMeleeComponent() != null) {
            int material = MaterialRegistry.getMaterialID(thrownItem);
            if (material < 0) {
                material = MaterialRegistry.getOrdinal(weapon.getMeleeComponent().weaponMaterial);
            }
            this.f_19804_.m_135381_(WEAPON_MATERIAL, (Object)material);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getMaterialColor() {
        int id = this.getWeaponMaterialId();
        if (id >= 0 && id < MATERIAL_COLORS.length) {
            return MATERIAL_COLORS[id];
        }
        return MaterialRegistry.getColorFromMaterialID(id);
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        ItemStack thrownItem = this.getWeapon();
        nbttagcompound.m_128365_("thrI", (Tag)thrownItem.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        if (nbttagcompound.m_128441_("thrI")) {
            this.setThrownItemStack(ItemStack.m_41712_((CompoundTag)nbttagcompound.m_128469_("thrI")));
        }
    }
}

