/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityMusketBullet
extends EntityProjectile<EntityMusketBullet> {
    public static final String ID = "bullet";
    public static final EntityType<EntityMusketBullet> TYPE = WMRegistries.createEntityType("bullet", new EntityDimensions(0.5f, 0.5f, false), EntityMusketBullet::new);

    public EntityMusketBullet(EntityType<EntityMusketBullet> entityType, Level world) {
        super(entityType, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
    }

    public EntityMusketBullet(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.m_6034_(d, d1, d2);
    }

    public EntityMusketBullet(Level world, LivingEntity shooter) {
        this(world, shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void m_37251_(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, f3, f4);
        Vec3 entityMotion = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(entityMotion.f_82479_, entity.m_20096_() ? 0.0 : entityMotion.f_82480_, entityMotion.f_82481_));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.inGround) {
            if (this.f_19796_.nextInt(4) == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            return;
        }
        double speed = this.getTotalVelocity();
        double amount = 16.0;
        if (speed > 2.0) {
            int i1 = 1;
            while ((double)i1 < amount) {
                Vec3 pos = this.m_20182_().m_82549_(this.m_20184_().m_82490_((double)i1 / amount));
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
                ++i1;
            }
        }
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        float damage = 20.0f + this.extraDamage;
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        if (entity.m_6469_(damagesource, damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxLifetime() {
        return 200;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public float getGravity() {
        return this.getTotalVelocity() < 3.0 ? 0.07f : 0.0f;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_MUSKET_BULLET.get());
    }
}

