/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.forge.EntityProjectileImpl;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityProjectile<T extends EntityProjectile<T>>
extends AbstractArrow
implements EntitySpawnExtension {
    private static final EntityDataAccessor<Byte> WEAPON_CRITICAL = SynchedEntityData.m_135353_(EntityProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    @Nullable
    protected BlockState inBlockState = null;
    protected boolean inGround = false;
    public PickupStatus pickupStatus;
    protected int ticksInGround;
    protected int ticksInAir;
    public boolean beenInGround;
    public float extraDamage;
    public int knockBack;
    private Entity shooter;

    public EntityProjectile(EntityType<T> type, Level world) {
        super(type, world);
        this.f_36706_ = 0;
        this.ticksInAir = 0;
        this.pickupStatus = PickupStatus.DISALLOWED;
        this.extraDamage = 0.0f;
        this.knockBack = 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WEAPON_CRITICAL, (Object)0);
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        Entity shooter = this.m_37282_();
        buf.writeInt(shooter != null ? shooter.m_142049_() : -1);
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        int shooterId = buf.readInt();
        if (shooterId >= 0) {
            this.m_5602_(this.f_19853_.m_6815_(shooterId));
        }
    }

    public void m_5602_(@Nullable Entity shooter) {
        this.shooter = shooter;
        super.m_5602_(shooter);
    }

    @Nullable
    public Entity m_37282_() {
        if (this.shooter != null) {
            return this.shooter;
        }
        return super.m_37282_();
    }

    protected float m_6380_(Pose pose, EntityDimensions dimension) {
        return 0.0f;
    }

    protected void setPickupStatusFromEntity(LivingEntity entityliving) {
        if (entityliving instanceof Player) {
            Player player = (Player)entityliving;
            if (player.m_7500_()) {
                this.setPickupStatus(PickupStatus.CREATIVE_ONLY);
            } else {
                this.setPickupStatus(WeaponModConfig.get().allCanPickup ? PickupStatus.ALLOWED : PickupStatus.OWNER_ONLY);
            }
        } else {
            this.setPickupStatus(PickupStatus.DISALLOWED);
        }
    }

    public Entity getDamagingEntity() {
        Entity shooter = this.m_37282_();
        return shooter != null ? shooter : this;
    }

    public void m_6686_(double x, double y, double z, float speed, float deviation) {
        Vec3 v = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * 0.0075 * (double)deviation, this.f_19796_.nextGaussian() * 0.0075 * (double)deviation, this.f_19796_.nextGaussian() * 0.0075 * (double)deviation).m_82490_((double)speed);
        this.m_20256_(v);
        double f2 = v.m_165924_();
        float n = (float)(Mth.m_14136_((double)v.f_82479_, (double)v.f_82481_) * 180.0 / Math.PI);
        this.m_146922_(n);
        this.f_19859_ = n;
        float n2 = (float)(Mth.m_14136_((double)v.f_82480_, (double)f2) * 180.0 / Math.PI);
        this.m_146926_(n2);
        this.f_19860_ = n2;
        this.ticksInGround = 0;
    }

    public void m_6001_(double d, double d1, double d2) {
        Vec3 v = new Vec3(d, d1, d2);
        this.m_20256_(v);
        if (this.aimRotation() && this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = v.m_165924_();
            float n = (float)(Mth.m_14136_((double)d, (double)d2) * 180.0 / Math.PI);
            this.m_146922_(n);
            this.f_19859_ = n;
            float n2 = (float)(Mth.m_14136_((double)d1, (double)f) * 180.0 / Math.PI);
            this.m_146926_(n2);
            this.f_19860_ = n2;
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            this.ticksInGround = 0;
        }
    }

    public void m_8119_() {
        this.m_6075_();
    }

    public void m_6075_() {
        Vec3 vec3d2;
        VoxelShape voxelShape;
        BlockPos blockpos;
        BlockState iblockstate;
        super.m_6075_();
        Vec3 motion = this.m_20184_();
        if (this.aimRotation() && this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = motion.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 180.0 / Math.PI));
            this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)f) * 180.0 / Math.PI));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if ((iblockstate = this.f_19853_.m_8055_(blockpos = new BlockPos(this.xTile, this.yTile, this.zTile))).m_60767_() != Material.f_76296_ && !(voxelShape = iblockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_() && voxelShape.m_83215_().m_82338_(blockpos).m_82390_(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()))) {
            this.inGround = true;
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        if (this.inGround) {
            if (!iblockstate.equals(this.inBlockState) && this.f_19853_.m_45772_(this.m_142469_().m_82400_(0.06))) {
                this.inGround = false;
                this.m_20256_(motion.m_82542_((double)(this.f_19796_.nextFloat() * 0.2f), (double)(this.f_19796_.nextFloat() * 0.2f), (double)(this.f_19796_.nextFloat() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else if (!this.f_19853_.f_46443_) {
                ++this.ticksInGround;
                int t = this.getMaxLifetime();
                if (t != 0 && this.ticksInGround >= t) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            ++this.f_36704_;
            return;
        }
        this.f_36704_ = 0;
        ++this.ticksInAir;
        Vec3 vec3d = this.m_20182_();
        BlockHitResult raytraceresult = this.f_19853_.m_45547_(new ClipContext(vec3d, vec3d2 = vec3d.m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vec3d2 = raytraceresult.m_82450_();
        }
        while (this.m_6084_()) {
            EntityHitResult entityraytraceresult = this.m_6351_(vec3d, vec3d2);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult instanceof EntityHitResult) {
                EntityHitResult ehr = (EntityHitResult)raytraceresult;
                Entity entity = ehr.m_82443_();
                Entity entity2 = this.m_37282_();
                if (entity instanceof Player) {
                    Player player2;
                    Player player = (Player)entity;
                    if (entity2 instanceof Player && !(player2 = (Player)entity2).m_7099_(player)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
            }
            if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !EntityProjectile.onProjectileImpact(this, (HitResult)raytraceresult)) {
                this.m_6532_((HitResult)raytraceresult);
                this.f_19812_ = true;
            }
            if (entityraytraceresult == null || this.m_36796_() <= 0) break;
            raytraceresult = null;
        }
        if (this.m_36792_()) {
            Vec3 motion2 = this.m_20184_();
            for (int i1 = 0; i1 < 2; ++i1) {
                Vec3 pos = this.m_20182_().m_82549_(motion2.m_82490_((double)i1 / 4.0));
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_, pos.f_82480_, pos.f_82481_, -motion2.f_82479_, -motion2.f_82480_ + 0.2, -motion2.f_82481_);
            }
        }
        Vec3 newPos = this.m_20182_().m_82549_(this.m_20184_());
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        if (this.aimRotation()) {
            Vec3 motion2 = this.m_20184_();
            double f2 = motion2.m_165924_();
            float n3 = (float)(Mth.m_14136_((double)motion2.f_82479_, (double)motion2.f_82481_) * 180.0 / Math.PI);
            this.m_146922_(n3);
            this.f_19859_ = n3;
            float n4 = (float)(Mth.m_14136_((double)motion2.f_82480_, (double)f2) * 180.0 / Math.PI);
            this.m_146926_(n4);
            this.f_19860_ = n4;
        }
        float res = this.getAirResistance();
        float grav = this.getGravity();
        if (this.m_20069_()) {
            Vec3 motion2 = this.m_20184_();
            this.beenInGround = true;
            for (int i2 = 0; i2 < 4; ++i2) {
                float f3 = 0.25f;
                Vec3 pos = this.m_20182_().m_82546_(motion2.m_82490_((double)f3));
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_, pos.f_82480_, pos.f_82481_, motion2.f_82479_, motion2.f_82480_ + 0.2, motion2.f_82481_);
            }
            res *= 0.6f;
        }
        this.m_20256_(this.m_20184_().m_82490_((double)res).m_82492_(0.0, this.m_20068_() ? 0.0 : (double)grav, 0.0));
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20101_();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean onProjectileImpact(EntityProjectile<?> projectile, HitResult hitResult) {
        void var1_1;
        return EntityProjectileImpl.onProjectileImpact(projectile, (HitResult)var1_1);
    }

    public void m_6532_(@NotNull HitResult result) {
        if (result instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)result;
            this.m_5790_(ehr);
        } else if (result instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)result;
            this.m_8060_(bhr);
        }
    }

    public void m_5790_(EntityHitResult result) {
        this.bounceBack();
        this.applyEntityHitEffects(result.m_82443_());
    }

    public void applyEntityHitEffects(Entity entity) {
        if (this.m_6060_() && !(entity instanceof EnderMan)) {
            entity.m_20254_(5);
        }
        if (entity instanceof LivingEntity) {
            double f;
            LivingEntity entityliving = (LivingEntity)entity;
            if (this.knockBack > 0 && (f = this.m_20184_().m_165925_()) > 0.0) {
                Vec3 v = this.m_20184_().m_82490_((double)this.knockBack * 0.6 / f);
                entity.m_5997_(v.f_82479_, 0.1, v.f_82481_);
            }
            Entity shooter = this.m_37282_();
            EnchantmentHelper.m_44823_((LivingEntity)entityliving, (Entity)shooter);
            if (shooter instanceof LivingEntity) {
                LivingEntity livingShooter = (LivingEntity)shooter;
                EnchantmentHelper.m_44896_((LivingEntity)livingShooter, (Entity)entityliving);
            }
            if (shooter instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)shooter;
                if (!entity.equals((Object)this.m_37282_()) && entity instanceof Player) {
                    sp.f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
            }
        }
    }

    public void m_8060_(BlockHitResult result) {
        BlockPos blockpos = result.m_82425_();
        this.xTile = blockpos.m_123341_();
        this.yTile = blockpos.m_123342_();
        this.zTile = blockpos.m_123343_();
        this.inBlockState = this.f_19853_.m_8055_(blockpos);
        this.m_20256_(result.m_82450_().m_82546_(this.m_20182_()));
        double f1 = this.m_20184_().m_82553_();
        Vec3 pos = this.m_20182_().m_82546_(this.m_20184_().m_82490_(0.05 / f1));
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.inGround = true;
        this.beenInGround = true;
        this.m_36762_(false);
        this.f_36706_ = this.getMaxArrowShake();
        this.playHitSound();
        if (this.inBlockState != null) {
            this.inBlockState.m_60682_(this.f_19853_, blockpos, (Entity)this);
        }
    }

    protected void bounceBack() {
        this.m_20256_(this.m_20184_().m_82490_(-0.1));
        this.m_146922_(this.m_146908_() + 180.0f);
        this.f_19859_ += 180.0f;
        this.ticksInAir = 0;
    }

    public double getTotalVelocity() {
        return this.m_20184_().m_82553_();
    }

    public boolean aimRotation() {
        return true;
    }

    public int getMaxLifetime() {
        return 1200;
    }

    public float getAirResistance() {
        return 0.99f;
    }

    public float getGravity() {
        return 0.05f;
    }

    public int getMaxArrowShake() {
        return 7;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.m_7941_();
    }

    public void playHitSound() {
    }

    public boolean canBeCritical() {
        return false;
    }

    public void m_36762_(boolean flag) {
        if (this.canBeCritical()) {
            this.f_19804_.m_135381_(WEAPON_CRITICAL, (Object)((byte)(flag ? 1 : 0)));
        }
    }

    public boolean m_36792_() {
        return this.canBeCritical() && (Byte)this.f_19804_.m_135370_(WEAPON_CRITICAL) != 0;
    }

    public void setExtraDamage(float f) {
        this.extraDamage = f;
    }

    public void m_36735_(int i) {
        this.knockBack = i;
    }

    public void setPickupStatus(PickupStatus i) {
        this.pickupStatus = i;
    }

    public PickupStatus getPickupStatus() {
        return this.pickupStatus;
    }

    public boolean canPickup(Player entityplayer) {
        if (this.pickupStatus == PickupStatus.ALLOWED) {
            return true;
        }
        if (this.pickupStatus == PickupStatus.CREATIVE_ONLY) {
            return entityplayer.m_7500_();
        }
        return this.pickupStatus == PickupStatus.OWNER_ONLY && entityplayer.equals((Object)this.m_37282_());
    }

    public void m_6123_(@NotNull Player entityplayer) {
        if (this.inGround && this.f_36706_ <= 0 && this.canPickup(entityplayer) && !this.f_19853_.f_46443_) {
            ItemStack item = this.m_7941_();
            if (item.m_41619_()) {
                return;
            }
            if (this.pickupStatus == PickupStatus.CREATIVE_ONLY && entityplayer.m_7500_() || entityplayer.m_150109_().m_36054_(item)) {
                this.m_5496_(SoundEvents.f_12019_, 0.2f, ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void onItemPickup(Player entityplayer) {
        entityplayer.m_7938_((Entity)this, 1);
    }

    public void m_7380_(CompoundTag nbttagcompound) {
        nbttagcompound.m_128405_("xTile", this.xTile);
        nbttagcompound.m_128405_("yTile", this.yTile);
        nbttagcompound.m_128405_("zTile", this.zTile);
        if (this.inBlockState != null) {
            nbttagcompound.m_128365_("inBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.inBlockState));
        }
        nbttagcompound.m_128344_("shake", (byte)this.f_36706_);
        nbttagcompound.m_128379_("inGround", this.inGround);
        nbttagcompound.m_128379_("beenInGround", this.beenInGround);
        nbttagcompound.m_128344_("pickup", (byte)this.pickupStatus.ordinal());
    }

    public void m_7378_(CompoundTag nbttagcompound) {
        this.xTile = nbttagcompound.m_128451_("xTile");
        this.yTile = nbttagcompound.m_128451_("yTile");
        this.zTile = nbttagcompound.m_128451_("zTile");
        if (nbttagcompound.m_128425_("inBlockState", 10)) {
            this.inBlockState = NbtUtils.m_129241_((CompoundTag)nbttagcompound.m_128469_("inBlockState"));
        }
        this.f_36706_ = nbttagcompound.m_128445_("shake") & 0xFF;
        this.inGround = nbttagcompound.m_128471_("inGround");
        this.beenInGround = nbttagcompound.m_128471_("beenInGround");
        this.pickupStatus = PickupStatus.getByOrdinal(nbttagcompound.m_128445_("pickup"));
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY,
        OWNER_ONLY;


        public static PickupStatus getByOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }
    }
}

