/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.IItemWeapon;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntitySpear
extends EntityMaterialProjectile<EntitySpear> {
    public static final String ID = "spear";
    public static final EntityType<EntitySpear> TYPE = WMRegistries.createEntityType("spear", new EntityDimensions(0.5f, 0.5f, false), EntitySpear::new);

    public EntitySpear(EntityType<EntitySpear> entityType, Level world) {
        super(entityType, world);
    }

    public EntitySpear(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.m_6034_(d, d1, d2);
    }

    public EntitySpear(Level world, LivingEntity shooter, ItemStack itemstack) {
        this(world, shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void m_37251_(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, f3, f4);
        Vec3 entityMotion = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(entityMotion.f_82479_, entity.m_20096_() ? 0.0 : entityMotion.f_82480_, entityMotion.f_82481_));
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        IItemWeapon iiw;
        if (this.f_19853_.f_46443_) {
            return;
        }
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem.m_41619_()) {
            return;
        }
        Item item = thrownItem.m_41720_();
        Entity entity = result.m_82443_();
        if (item instanceof IItemWeapon && entity.m_6469_(damagesource, (iiw = (IItemWeapon)item).getMeleeComponent().getEntityDamage() + this.getMeleeHitDamage(entity))) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            if (thrownItem.m_41773_() + 1 >= thrownItem.m_41776_()) {
                thrownItem.m_41774_(1);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                ServerPlayer sp;
                Entity shooter = this.m_37282_();
                thrownItem.m_41629_(1, this.f_19796_, shooter instanceof ServerPlayer ? (sp = (ServerPlayer)shooter) : null);
                this.m_6001_(0.0, 0.0, 0.0);
            }
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void playHitSound() {
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.0f / (this.f_19796_.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public int getMaxLifetime() {
        return this.pickupStatus == EntityProjectile.PickupStatus.ALLOWED || this.pickupStatus == EntityProjectile.PickupStatus.OWNER_ONLY ? 0 : 1200;
    }

    @Override
    public int getMaxArrowShake() {
        return 10;
    }
}

