/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.entity.projectile.EntityFlail;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemFlail
extends ItemMelee {
    public static final String WOOD_ID = "flail.wood";
    public static final ItemFlail WOOD_ITEM = WMItemBuilder.createStandardFlail((Tier)Tiers.WOOD);
    public static final String STONE_ID = "flail.stone";
    public static final ItemFlail STONE_ITEM = WMItemBuilder.createStandardFlail((Tier)Tiers.STONE);
    public static final String IRON_ID = "flail.iron";
    public static final ItemFlail IRON_ITEM = WMItemBuilder.createStandardFlail((Tier)Tiers.IRON);
    public static final String GOLD_ID = "flail.gold";
    public static final ItemFlail GOLD_ITEM = WMItemBuilder.createStandardFlail((Tier)Tiers.GOLD);
    public static final String DIAMOND_ID = "flail.diamond";
    public static final ItemFlail DIAMOND_ITEM = WMItemBuilder.createStandardFlail((Tier)Tiers.DIAMOND);
    public static final String NETHERITE_ID = "flail.netherite";
    public static final ItemFlail NETHERITE_ITEM = WMItemBuilder.createStandardFlail((Tier)Tiers.NETHERITE);
    private final float flailDamage;

    public ItemFlail(MeleeComponent meleecomponent) {
        super(meleecomponent);
        this.flailDamage = 4.0f + meleecomponent.weaponMaterial.m_6631_();
    }

    @Override
    public int m_6473_() {
        return 0;
    }

    @Override
    public void m_6883_(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull Entity entity, int i, boolean flag) {
        Entity entity2;
        int id;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.isThrown(player)) {
            return;
        }
        ItemStack itemstack2 = player.m_21205_();
        if (itemstack2.m_41619_() || !(itemstack2.m_41720_() instanceof ItemFlail)) {
            this.setThrown(player, false);
        } else if (itemstack2.m_41720_() == this && (id = PlayerWeaponData.getFlailEntityId(player)) != 0 && (entity2 = world.m_6815_(id)) instanceof EntityFlail) {
            EntityFlail flail = (EntityFlail)entity2;
            flail.m_5602_((Entity)player);
            flail.setThrownItemStack(itemstack);
        }
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player entityplayer, @NotNull InteractionHand hand) {
        ItemStack itemstack = entityplayer.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        this.removePreviousFlail(world, entityplayer);
        entityplayer.m_6674_(hand);
        if (!entityplayer.m_7500_()) {
            itemstack.m_41622_(1, (LivingEntity)entityplayer, s -> {
                s.m_21190_(InteractionHand.MAIN_HAND);
                this.setThrown(entityplayer, false);
            });
        }
        if (!itemstack.m_41619_()) {
            this.throwFlail(itemstack, world, entityplayer);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public boolean m_7579_(@NotNull ItemStack itemstack, @NotNull LivingEntity entityliving, @NotNull LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            this.m_7203_(attacker.f_19853_, player, InteractionHand.MAIN_HAND);
        }
        return true;
    }

    public void throwFlail(ItemStack itemstack, Level world, Player entityplayer) {
        world.m_6263_(null, entityplayer.m_20185_(), entityplayer.m_20186_(), entityplayer.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 0.5f, 0.4f / (entityplayer.m_21187_().nextFloat() * 0.4f + 0.8f));
        if (!world.f_46443_) {
            EntityFlail entityflail = new EntityFlail(world, (LivingEntity)entityplayer, itemstack);
            entityflail.m_37251_((Entity)entityplayer, entityplayer.m_146909_(), entityplayer.m_146908_(), 0.0f, 0.75f, 3.0f);
            PlayerWeaponData.setFlailEntityId(entityplayer, entityflail.m_142049_());
            world.m_7967_((Entity)entityflail);
            this.setThrown(entityplayer, true);
        }
    }

    public void setThrown(Player entityplayer, boolean flag) {
        PlayerWeaponData.setFlailThrown(entityplayer, flag);
    }

    public boolean isThrown(Player entityplayer) {
        return PlayerWeaponData.isFlailThrown(entityplayer);
    }

    private void removePreviousFlail(Level world, Player entityplayer) {
        Entity entity;
        int id = PlayerWeaponData.getFlailEntityId(entityplayer);
        if (id != 0 && (entity = world.m_6815_(id)) instanceof EntityFlail) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public float getFlailDamage() {
        return this.flailDamage;
    }
}

