/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import ckathode.weaponmod.item.WMItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemMelee
extends SwordItem
implements IItemWeapon {
    public static final String KATANA_WOOD_ID = "katana.wood";
    public static final ItemMelee KATANA_WOOD_ITEM = WMItemBuilder.createStandardKatana((Tier)Tiers.WOOD);
    public static final String KATANA_STONE_ID = "katana.stone";
    public static final ItemMelee KATANA_STONE_ITEM = WMItemBuilder.createStandardKatana((Tier)Tiers.STONE);
    public static final String KATANA_IRON_ID = "katana.iron";
    public static final ItemMelee KATANA_IRON_ITEM = WMItemBuilder.createStandardKatana((Tier)Tiers.IRON);
    public static final String KATANA_GOLD_ID = "katana.gold";
    public static final ItemMelee KATANA_GOLD_ITEM = WMItemBuilder.createStandardKatana((Tier)Tiers.GOLD);
    public static final String KATANA_DIAMOND_ID = "katana.diamond";
    public static final ItemMelee KATANA_DIAMOND_ITEM = WMItemBuilder.createStandardKatana((Tier)Tiers.DIAMOND);
    public static final String KATANA_NETHERITE_ID = "katana.netherite";
    public static final ItemMelee KATANA_NETHERITE_ITEM = WMItemBuilder.createStandardKatana((Tier)Tiers.NETHERITE);
    public final MeleeComponent meleeComponent;

    public ItemMelee(@NotNull MeleeComponent meleecomponent) {
        this(meleecomponent, WMItem.getBaseProperties(meleecomponent.weaponMaterial));
    }

    public ItemMelee(@NotNull MeleeComponent meleecomponent, Item.Properties properties) {
        super((Tier)(meleecomponent.weaponMaterial == null ? Tiers.WOOD : meleecomponent.weaponMaterial), 3, -2.4f, meleecomponent.setProperties(properties).m_41491_(CreativeModeTab.f_40757_));
        this.meleeComponent = meleecomponent;
        this.meleeComponent.setItem(this);
    }

    public float m_43299_() {
        return this.meleeComponent.getDamage();
    }

    public float m_8102_(@NotNull ItemStack itemstack, @NotNull BlockState block) {
        return this.meleeComponent.getDestroySpeed(itemstack, block);
    }

    public boolean m_8096_(BlockState block) {
        return this.meleeComponent.canHarvestBlock(block);
    }

    public boolean m_7579_(@NotNull ItemStack itemstack, @NotNull LivingEntity entityliving, @NotNull LivingEntity attacker) {
        return this.meleeComponent.hurtEnemy(itemstack, entityliving, attacker);
    }

    public boolean m_6813_(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull BlockState block, @NotNull BlockPos pos, @NotNull LivingEntity entityliving) {
        return this.meleeComponent.mineBlock(itemstack, world, block, pos, entityliving);
    }

    public int m_6473_() {
        return this.meleeComponent.getEnchantmentValue();
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemstack) {
        return this.meleeComponent.getUseAnimation(itemstack);
    }

    public int m_8105_(@NotNull ItemStack itemstack) {
        return this.meleeComponent.getUseDuration(itemstack);
    }

    @Override
    public boolean onLeftClickEntity(@NotNull ItemStack itemstack, @NotNull Player player, @NotNull Entity entity) {
        return this.meleeComponent.onLeftClickEntity(itemstack, player, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player entityplayer, @NotNull InteractionHand hand) {
        return this.meleeComponent.use(entityplayer.m_21120_(hand), world, entityplayer, hand);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.meleeComponent.onUsingTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void m_5551_(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull LivingEntity entityplayer, int i) {
        this.meleeComponent.releaseUsing(itemstack, world, entityplayer, i);
    }

    public void m_6883_(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull Entity entity, int i, boolean flag) {
        this.meleeComponent.inventoryTick(itemstack, world, entity, i, flag);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            this.meleeComponent.addItemAttributeModifiers((Multimap<Attribute, AttributeModifier>)multimap);
        }
        return multimap;
    }

    @Override
    public MeleeComponent getMeleeComponent() {
        return this.meleeComponent;
    }

    @Override
    public RangedComponent getRangedComponent() {
        return null;
    }
}

