/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.item.ItemShooter;
import ckathode.weaponmod.item.MeleeCompKnife;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedCompMusket;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMusket
extends ItemShooter {
    public static final String ID = "musket";
    public static final ItemMusket ITEM = WMItemBuilder.createStandardMusket();
    public static final String WOOD_ID = "musketbayonet.wood";
    public static final ItemMusket WOOD_ITEM = WMItemBuilder.createStandardMusketWithBayonet((Tier)Tiers.WOOD, (Item)MeleeCompKnife.WOOD_ITEM);
    public static final String STONE_ID = "musketbayonet.stone";
    public static final ItemMusket STONE_ITEM = WMItemBuilder.createStandardMusketWithBayonet((Tier)Tiers.STONE, (Item)MeleeCompKnife.STONE_ITEM);
    public static final String IRON_ID = "musketbayonet.iron";
    public static final ItemMusket IRON_ITEM = WMItemBuilder.createStandardMusketWithBayonet((Tier)Tiers.IRON, (Item)MeleeCompKnife.IRON_ITEM);
    public static final String GOLD_ID = "musketbayonet.gold";
    public static final ItemMusket GOLD_ITEM = WMItemBuilder.createStandardMusketWithBayonet((Tier)Tiers.GOLD, (Item)MeleeCompKnife.GOLD_ITEM);
    public static final String DIAMOND_ID = "musketbayonet.diamond";
    public static final ItemMusket DIAMOND_ITEM = WMItemBuilder.createStandardMusketWithBayonet((Tier)Tiers.DIAMOND, (Item)MeleeCompKnife.DIAMOND_ITEM);
    public static final String NETHERITE_ID = "musketbayonet.netherite";
    public static final ItemMusket NETHERITE_ITEM = WMItemBuilder.createStandardMusketWithBayonet((Tier)Tiers.NETHERITE, (Item)MeleeCompKnife.NETHERITE_ITEM);
    @Nullable
    protected final Item bayonetItem;
    private final int bayonetDurability;

    public ItemMusket(MeleeComponent meleecomponent, @Nullable Item bayonetitem) {
        super(new RangedCompMusket(), meleecomponent);
        this.bayonetItem = bayonetitem;
        this.bayonetDurability = meleecomponent.meleeSpecs != MeleeComponent.MeleeSpecs.NONE && meleecomponent.weaponMaterial != null ? meleecomponent.meleeSpecs.durabilityBase + (int)((float)meleecomponent.weaponMaterial.m_6609_() * meleecomponent.meleeSpecs.durabilityMult) : 0;
    }

    public boolean hasBayonet() {
        return this.bayonetItem != null;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        short dmg;
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (this.hasBayonet() && stack.m_41782_() && stack.m_41783_().m_128425_("bayonetDamage", 2) && (dmg = stack.m_41783_().m_128448_("bayonetDamage")) != 0) {
            tooltipComponents.add((Component)new TranslatableComponent("tooltip.bayonetdurability", new Object[]{this.bayonetDurability - dmg, this.bayonetDurability}));
        }
    }

    @Override
    public boolean m_7579_(@NotNull ItemStack itemstack, @NotNull LivingEntity entityliving, @NotNull LivingEntity attacker) {
        if (this.hasBayonet()) {
            Player player;
            int n = entityliving.f_19802_;
            Objects.requireNonNull(entityliving);
            if (n == 20) {
                float kb = this.meleeComponent.getKnockBack(itemstack, entityliving, attacker);
                PhysHelper.knockBack(entityliving, attacker, kb);
                entityliving.f_19802_ -= (int)(2.0f / this.meleeComponent.meleeSpecs.attackDelay);
            }
            if (attacker instanceof Player && !(player = (Player)attacker).m_7500_()) {
                this.bayonetDamage(itemstack, attacker, 1);
            }
        }
        return true;
    }

    @Override
    public boolean m_6813_(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull BlockState block, @NotNull BlockPos pos, @NotNull LivingEntity entityliving) {
        if (this.hasBayonet()) {
            Player player;
            boolean flag;
            Material material = block.m_60767_();
            boolean bl = flag = material != Material.f_76300_ && material != Material.f_76302_ && material != Material.f_76301_ && material != Material.f_76274_ && material != Material.f_76285_;
            if (entityliving instanceof Player && !(player = (Player)entityliving).m_7500_() && flag) {
                this.bayonetDamage(itemstack, entityliving, 2);
            }
        }
        return true;
    }

    public void bayonetDamage(ItemStack itemstack, LivingEntity entityliving, int damage) {
        int bayonetdamage;
        if (itemstack.m_41783_() == null) {
            itemstack.m_41751_(new CompoundTag());
        }
        if ((bayonetdamage = itemstack.m_41783_().m_128448_("bayonetDamage") + damage) > this.bayonetDurability) {
            entityliving.m_21190_(InteractionHand.MAIN_HAND);
            if (entityliving instanceof Player) {
                Player player = (Player)entityliving;
                player.m_36246_(Stats.f_12983_.m_12902_((Object)this));
            }
            bayonetdamage = 0;
            ItemStack itemstack2 = new ItemStack((ItemLike)WMRegistries.ITEM_MUSKET.get(), 1);
            itemstack2.m_41721_(itemstack.m_41773_());
            entityliving.m_8061_(EquipmentSlot.MAINHAND, itemstack2);
            if (itemstack.m_41783_().m_128441_("rld")) {
                ReloadHelper.setReloadState(itemstack2, ReloadHelper.getReloadState(itemstack));
            }
        }
        itemstack.m_41783_().m_128376_("bayonetDamage", (short)bayonetdamage);
    }
}

