/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import ckathode.weaponmod.item.WMItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemShooter
extends BowItem
implements IItemWeapon {
    protected static final int MAX_DELAY = 72000;
    public final RangedComponent rangedComponent;
    public final MeleeComponent meleeComponent;

    public ItemShooter(RangedComponent rangedcomponent, MeleeComponent meleecomponent) {
        this(rangedcomponent, meleecomponent, WMItem.getBaseProperties(meleecomponent.weaponMaterial));
    }

    public ItemShooter(RangedComponent rangedcomponent, MeleeComponent meleecomponent, Item.Properties properties) {
        super(rangedcomponent.setProperties(properties).m_41491_(CreativeModeTab.f_40757_));
        this.rangedComponent = rangedcomponent;
        this.meleeComponent = meleecomponent;
        rangedcomponent.setItem(this);
        meleecomponent.setItem(this);
    }

    public float m_8102_(@NotNull ItemStack itemstack, @NotNull BlockState block) {
        return this.meleeComponent.getDestroySpeed(itemstack, block);
    }

    public boolean m_8096_(BlockState state) {
        return this.meleeComponent.canHarvestBlock(state);
    }

    public boolean m_7579_(@NotNull ItemStack itemstack, @NotNull LivingEntity entityliving, @NotNull LivingEntity attacker) {
        return this.meleeComponent.hurtEnemy(itemstack, entityliving, attacker);
    }

    public boolean m_6813_(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull BlockState block, @NotNull BlockPos pos, @NotNull LivingEntity entityliving) {
        return this.meleeComponent.mineBlock(itemstack, world, block, pos, entityliving);
    }

    public int m_6473_() {
        return this.meleeComponent.getEnchantmentValue();
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            this.meleeComponent.addItemAttributeModifiers((Multimap<Attribute, AttributeModifier>)multimap);
            this.rangedComponent.addItemAttributeModifiers((Multimap<Attribute, AttributeModifier>)multimap);
        }
        return multimap;
    }

    @Override
    public boolean onLeftClickEntity(@NotNull ItemStack itemstack, @NotNull Player player, @NotNull Entity entity) {
        return this.meleeComponent.onLeftClickEntity(itemstack, player, entity) && this.rangedComponent.onLeftClickEntity(itemstack, player, entity);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemstack) {
        return this.rangedComponent.getUseAnimation(itemstack);
    }

    public int m_8105_(@NotNull ItemStack itemstack) {
        return this.rangedComponent.getUseDuration(itemstack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player entityplayer, @NotNull InteractionHand hand) {
        return this.rangedComponent.use(entityplayer.m_21120_(hand), world, entityplayer, hand);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.rangedComponent.onUsingTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void m_5551_(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull LivingEntity entityplayer, int i) {
        this.rangedComponent.releaseUsing(itemstack, world, entityplayer, i);
    }

    public void m_6883_(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull Entity entity, int i, boolean flag) {
        this.meleeComponent.inventoryTick(itemstack, world, entity, i, flag);
        this.rangedComponent.inventoryTick(itemstack, world, entity, i, flag);
    }

    @Override
    public MeleeComponent getMeleeComponent() {
        return this.meleeComponent;
    }

    @Override
    public RangedComponent getRangedComponent() {
        return this.rangedComponent;
    }
}

